/***************************************************************************
                               controlimp.cpp
                             -------------------
    begin                : Wednesday March 28 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : ben@meyerhome.net
 ***************************************************************************/

#include "controlimp.h"
#include <qtoolbutton.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <qstring.h>

/**
 * Set up signals.
 * @param parent the parent widget
 * @param name the name of this widget
 */
ChatRoomControlImp::ChatRoomControlImp(QWidget *parent, const char *name) : ChatRoomControl( parent,name,false )
, _Menu(NULL){
  connect( buddyList, SIGNAL(rightButtonClicked(QListBoxItem *, const QPoint &)), this, SLOT(rightClick(QListBoxItem *, const QPoint &)) );
  connect( buddyList, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(doubleClick(QListBoxItem *)));
}


/**
 * A buddy has been updated, add or remove as needed.  Update count.
 * @param buddy the name of the buddy
 * @param curstat the current status of 'contactName'
 */
void ChatRoomControlImp::updateContact(QString contactName, bool newStatus){
  if (newStatus == true)
    buddyList->insertItem(contactName);
  else{
    int count = buddyList->count();
    int index = -1;
    for(int i=0; i< count; i++){
      QString bud = buddyList->text(i);
      if (bud == contactName)
        index = i;
      // Check ignore case;
      if(contactName.mid(0,1) == QString("*"))
        if ( bud.mid(1,bud.length()-1) == contactName)
          index = i;
    }
    if (index != -1)
      buddyList->removeItem(index);
  }
  QString people;
  if (buddyList->count() == 1)
    people = "1 person";
  else
    people = QString("%1 people").arg(buddyList->count());
  numberOfPeople->setText(people);
  if ( buddyList->currentItem() == -1)
    buddyList->setCurrentItem ( buddyList->firstItem() ) ;
}

/**
 * Determine if 'contactName' should be ignored.
 * @param buddy name to test against.
 * @return if the buddy should be ignored or not.
 */
bool ChatRoomControlImp::ignore( QString contactName ){
  QString ignoreBuddy = QString("*") + contactName;
  int count = buddyList->count();
  for(int i=0; i< count; i++){
    if ( (buddyList->text(i)) == ignoreBuddy)
      return true;
  }
  return false;
}

/**
 * If a contact is selected send out a signal to get there info.
 */
void ChatRoomControlImp::infoClicked(){
  if ( buddyList->currentItem() == -1)
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
  else
    emit ( getInfo(buddyList->currentText()) );
}

/**
 * When you ignore someone put an asteric next to there name to show that you
 * will ignore them.  If they have one, remove it.
 */
void ChatRoomControlImp::ignoreClicked(){
  int curBuddy = buddyList->currentItem();
  if ( curBuddy == -1){
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
    return;
  }
  QString buddy = buddyList->text(curBuddy);
  if (buddy == owner){
    QMessageBox::information(this, "Kinkatta - Message","You can not ignore yourself.", QMessageBox::Ok);
    return;
  }

  // Make sure we havn't ignored them already.
  if (buddy.mid(0,1) != QString("*")){
    buddy = QString("*") + buddy;
    buddyList->changeItem ( buddy,curBuddy );
  }
  else{
    buddy = buddy.mid(1,buddy.length()-1);
    buddyList->changeItem ( buddy,curBuddy );
  }
}

/**
 * If a contact is selected send out a signal to open a chat with them.
 */
void ChatRoomControlImp::imClicked(){
  if ( buddyList->currentItem() == -1)
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
  else
    emit ( im(buddyList->currentText()) );
}


/**
 * If a contact is double-clicked send out a signal to open a chat with them.
 */
void ChatRoomControlImp::doubleClick( QListBoxItem* ){
  if ( buddyList->currentItem() == -1)
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
  else
    emit ( im(buddyList->currentText()) );
}


/**
 * When you right click on a contact this is the menu that pops up.
 * @param pos the current position of the cursor
 */
void ChatRoomControlImp::rightClick(QListBoxItem *, const QPoint &pos){
  if ( buddyList->currentItem() == -1 /*|| buddyList->itemAt(pos) == NULL*/ ){
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
    return;
  }

  if(_Menu == NULL){
    _Menu = new KPopupMenu(this, "rightclickmenu");
    _Menu->clear();
    _Menu->insertItem(SmallIcon("chat"), "&IM", this, SLOT(imClicked()));
    _Menu->insertItem(SmallIcon("fileclose"), "&Ignore", this, SLOT(ignoreClicked()));
    _Menu->insertItem(SmallIcon("buddy_info"), "&Info", this, SLOT(infoClicked()));
  }

  _Menu->exec(pos);
}

// contolimp.cpp

