/***************************************************************************
                          dockpopup.h 
                       -------------------
  begin                : Nov 10 2001
  copyright            : (C) 2001 by Dimi Shahbaz
  email                : dshahbaz@ucla.edu
 ***************************************************************************/

#ifndef DOCKPOPUP_H
#define DOCKPOPUP_H

#include <qwidget.h>
#include <qlabel.h>

class QBitmap;

/**
 * An popup window that displays information about buddies logging in and out.
 * Is not managed by the WM so it doesn't annoy the user.
 * @author Dimi Shahbaz
 */
class DockPopup : public QWidget {

Q_OBJECT

public:

  /// Constructor 
  DockPopup( QWidget *parent=0, const char *name=0);

  /// Destructor 
  ~DockPopup();

  /// Where to place the anchor on the popup
  enum Position{ BottomRight=1, BottomLeft, TopRight, TopLeft };

  /// Add text to the popup
  void setText(QString );

  /// Place the anchor on the popup
  void setAnchor(QPoint , Position=BottomRight );

  /// Return the point of the anchor
  QPoint anchor(void){ return mAnchor; }

  /// Return the position of the anchor
  Position anchorPosition(void) { return mAnchorPosition; }

signals:

  /// Emitted when the user moves the popup by dragging the anchor
  void anchorMoved( );

protected:

  void mousePressEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  void mouseMoveEvent( QMouseEvent * );
  void paintEvent( QPaintEvent * );

private:
  QString mText;
  QBitmap *mMask;
  QPixmap *mTextPixmap;

  /**
   * Derived class so we can have access to the drawContens method (which is
   * normally protected under QLabel)
   */
  class DockLabel : public QLabel {
  
  public:
    DockLabel(QWidget *, const char *);
    void drawContents( QPainter * );
  };

  DockLabel *mLabel;

  QPalette mPalette;
  QFont mFont;
  QPoint mAnchor;
  Position mAnchorPosition;

  /// For moving the popup
  QPoint mClickPos;
  /// For indication of where the popup is being "anchored" when being moved.
  bool drawAnchorPosition; 

};

#endif 

// dockpopup.h

