/***************************************************************************
			                    kinkattadock.h  -  description
			                       -------------------
		begin                : May 10 2001
		copyright            : (C) 2001 by Dimi Shahbaz
		email                : dshahbaz@ucla.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <ksystemtray.h>
#include "tbuddylist.h"
#include "setup.h"		          // AIM Settings
#include "dockpopup.h"

class KPopupMenu;
class QLabel;

#include <qpixmap.h>

/**
 * The Dock widget sits in the system tray and can exec commands from that location.
 * @author Dimi Shahbaz
 */
class DockWidget : public /*KDockWindow */ KSystemTray{
  
Q_OBJECT

public:
  DockWidget(QWidget *parent = 0, const char *name=0);
  ~DockWidget();
  KPopupMenu *awayMenu;
	
signals:
  /// Hide Kinkatta (either the main window or login)
  void hideKinkatta();
  /// Show Kinkatta (either the main window or login)
  void showKinkatta();
  void hideAll();
  void showAll();
  /// Show Kinkatta's configureation window.
  void showKinkattaConfig();
  /// Show Kinkatta's plugin configuration window.
  void showKinkattaPlugins();
  /// Exit application
  void exitKinkatta();
  /// Try to connect (called when not online)
  void tryToConnect();
  /// Logoff (called when online)
  void logoff();
  /// Come back from away
  void backClicked();


protected:
  void paintEvent(QPaintEvent *e);

public slots:
  /// Called when the connection state changes
  void connectionChanged(int);

  /// Called when a buddy signs on 
  void buddySignedOn(TBuddy *);

  /// Called when a buddy signs off
  void buddySignedOff(TBuddy *);

  /// Saves the position of the dock tooltip popup if it is manually moved
  void popupAnchorMoved();


private slots:

  /// Connects or disconnects the user
  void signOnClicked();

  /// Called when the dock applet is left clicked
  void showKinkattaClicked();

  /// Toggles visibility of all windows
  void showAllClicked();

  /// Handles clicks on the dock applet
  void mousePressEvent(QMouseEvent *e);

  /// Redraws the icons
  void paintIcon();

  /// Enables delaying the signon popup
  void signonPopupDelayedEnable();

  /// Add a name to the popups list
  void popupPushItem(QString );

  /// Removes the first name from the popups list
  void popupPopItem();

private:
  bool kinkattaVisible;
  bool allVisible;
  bool delaySignonPopup;
  int connectionState; //TAIM_(AWAY|ONLINE|OFFLINE)
  int showKinkattaID;
  int showAllKinkattaID; //this is for visibility of all Kinkatta windows.
  int signonID;
  int awayMenuID;

  KPopupMenu *popup_m;

  QLabel *toolTip;

  QPixmap dock_offline_pixmap;
  QPixmap dock_online_pixmap;
  QPixmap dock_away_pixmap;
  QPixmap signonIcon;
  QPixmap signoffIcon;

  //These are to maintain the signon/signoff tooltip
  QStringList popupItems;
  DockPopup *dockPopup;

  //To check if the popup is enabled in the settings
  settings_t *i_aimSettings;

};

#endif

