// taim.h
//
// Kit AIM client
//
// For copyright and license, see accompanying documentation

#ifndef TAIM_H
#define TAIM_H

extern "C"
{
#include <time.h>
}

#include <qobject.h>
#include "aim.h"
class QString;
class tbuddylist;

// forward declaration
class KitSocket;

typedef struct TAimConfig
{
	int permitStatus;
	TBuddyList buddyList;
	TBuddyList permitList;
	TBuddyList denyList;
};

class TAim : public QObject
{
  Q_OBJECT

  public:
    TAim(QObject *parent = 0, const char *name = 0);
    ~TAim();

		inline const TBuddyList &buddyList(void) { return currentConfig.buddyList; };
		inline const TBuddyList &permitList(void) { return currentConfig.permitList; };
		inline const TBuddyList &denyList(void) { return currentConfig.denyList; };
		inline int permissions(void) { return currentConfig.permitStatus; };

		void setBuddyList(const TBuddyList &);
		void setPermitList(const TBuddyList &);
		void setDenyList(const TBuddyList &);
		void setPermissions(int);
                void tocremoveBuddy(const TBuddyList &, const QString &);
                void tocaddBuddy(const TBuddyList &, const QString &);

		inline int getStatus(void) { return status; };
		inline QString getUserName(void) { return username; };
		inline QString getInfo() { return userInfo; };
		void doKeepAlive(int);
		void doIdleTime(bool);
		void setIdleTime(int time);

    void useCustomServer(int);
    void setCustomServer(const QString &, int, const QString &, int);

    void useSocksServer(bool);
    void setSocksProxy(const QString &socksServer, unsigned short socksPort,
    bool doUsernameAuth = false,
    const QString &username = QString::null,
    const QString &password = QString::null);
    bool useX11forIdle;
    int idleTimeBeforeSignal;
    bool idleStringWColon;
		
		// get at the configuration stored on the server
		inline const TBuddyList &serverBuddyList(void) { return serverConfig.buddyList; };
		inline const TBuddyList &serverPermitList(void) { return serverConfig.permitList; };
		inline const TBuddyList &serverDenyList(void) { return serverConfig.denyList; };
		inline int serverPermissions(void) { return serverConfig.permitStatus; };

		void setServerBuddyList(const TBuddyList &);
		void setServerPermitList(const TBuddyList &);
		void setServerDenyList(const TBuddyList &);
		void setServerPermissions(int);
		
		struct directory
		{
			QString firstName;
			QString middleName;
			QString lastName;
			QString maidenName;
			QString city;
			QString state;
			QString country;
			QString email;
			bool allowWebSearches;
		};
	
	public slots:
		void setStatus(int);
		void setUserName(const QString &);
		void setPassword(const QString &);
		// setAwayMessage ends idleness if message == QString::null
		void setAwayMessage(const QString & = QString::null);
		// setUserInfo ends idleness, if online
		void setUserInfo(const QString &);
		// requestUserInfo ends idleness
		void requestUserInfo(const QString &);
		// sendIM: message, target, auto
		// sendIM ends idleness
		void sendIM(QString, QString, bool, bool);
		// sendWarning: target, anonymous
		// sendWarning ends idleness
		void sendWarning(QString, bool);

		void changePassword(QString oldPassword, QString newPassword);

		// requestDirectory ends idleness
		void requestDirectory(const QString &);
		// setDirectory ends idleness
		void setDirectory(const directory &);
		// searchDirectory ends idleness
		void searchDirectory(const directory &);

		// Progress Bar for connecting sequence: when cancel is pressed
		void cancelProgress(void);

		void chatJoin(QString name, int Exchange);
		void chatSend(int room, QString message);
		void chatWhisper(int room, QString dst_bud, QString message);
		void chatInvite(int room, QString message, QString buddy);
		void chatLeave(int room);
		void chatAccept(int room);

	signals:
		void reloadList();
		void debugDataIn(QString data);
		void statusChanged(int);	
		void configChanged(void);
		void buddyChanged(int);
		void idleTimeReached();

		void nick(QString name);

		void userSignedOn(QString);
		void userSignedOn(QString name, QString alias);
		/// A buddyChanged signal will also be emited with userSignedOff
		void userSignedOff(QString);
		void userSignedOff(QString name, QString alias);
		void userNotIdle(QString);
		void userNotAway(QString);
		    
		void userNameChanged(void);
		void userInfoReceived(QString);
		// IMReceived: QString name, QString msg, bool auto
		void IMReceived(QString, QString, bool);
		void warningReceived(int, QString);
		void warningReduced(int, QString);
	
		void chat_joined(int, QString);
		void chat_in(int, QString, bool, QString);
		void chat_updateBuddy(int, bool, QString);
		void chat_invite(QString, int, QString, QString);
		void chat_left(int);
	
		// Progress Bar for connecting sequence
		// int max sequence number, int sequence number, QString message
		void initProgress(int, int, QString);
		// int sequence number, QString message
		void updateProgress(int, QString);
		void endProgress(void);

		// error messages (from server, and local)
		void displayError(QString);
	protected slots:
		// part of the sign-on process.. connected in turn to socket::readData signal
		void tocConnect(void);
		void tocConnect1(void);
		void tocConnect2(void);
		void tocConnect3(void);
		void onDisconnect(void);
		// parsing commands from the server
		void tocServer(void);
		// idleTime
		void endIdleness(void);
		void updateIdleness(void);
	private:
		int status;
		KitSocket *socket;

		TAimConfig currentConfig, serverConfig;

		int keepAlive;

    bool timerLock;


		int usingCustomServer;
		QString server;
		int serverPort;
		QString authorizer;
		int authorizerPort;

		bool useSocks;
		QString socksServer;
		unsigned short socksPort;
		bool useSocksAuth;
		QString socksName;
		QString socksPassword;

		// so we don't send the buddy list n times
		QString lastListSent;
		int lastPermissionSent;
		QString lastInfoSent;
		QString lastConfigSent;

		// secondary thread host lookup stuff
		int hostThreadReturn;

		// user information and configuration
		QString username;
		QString r_password;
		QString userInfo;

		// save old warning level, so we can tell the difference between warnings and reductions
		int oldEvil;

		// idleness
		bool updateIdleTime;
		time_t idleTime;
		bool isIdle;

		// private functions
		void tocSignon(const QString &auth_host, const QString &auth_port, const QString &lang);
		void tocInitDone(void);
		void setConfig(void);
		void sendConfig(void);
		void sendPermissions(void);
		void sendUserInfo(void);
		void doNick(const QString &);
		void doUpdate(const QString &);
		void doIM(const QString &);
		void doEviled(const QString &);
		void doError(const QString &);
		void doPasswordMessage(const QString &);

		void doChatJoin(const QString &);
		void doChatIn(const QString &);
		void doChatUpdateBuddy(const QString &);
		void doChatInvite(const QString &);
		void doChatLeft(const QString &);
};

#endif

