/***************************************************************************
                                   babel.h
                             -------------------
    begin                : Tuesday Nov 11 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTAPLUGINBABEL_H
#define KINKATTAPLUGINBABEL_H

#include <qsocket.h>
class QString;
class QSocket;

/**
 * Used in translating a message.  Once the text has been translated a signal
 * is emitted with the new text. 
 * @author Benjamin Meyer
 */
class Babel : public QSocket {

Q_OBJECT

signals:
  /// A going out message for buddy has been translated.
  void translatedOut( QString message, QString buddy );
  
  /// A going in message for buddy has been translated.
  void translatedIn( QString message, QString buddy );

public:
  /// Constructor.
  Babel( QWidget *parent, const char *name );
  
  /// Deconstructor.
  virtual ~Babel();
  
  /// Translates a message that is passed in.
  virtual void translate( QString message, QString buddy, bool in );
  
  /// Sets the type of translation to be used (Ex: French->English)
  void setType( QString newType );

private slots:
  /// Called once the page has been downloaded.
  void done();
  
  /// There is more to the page, it is fetched.
  void incoming();
  
  /// Send a message out to the server. 
  void sendOut( QString message );
  
  /// Remove any html.
  void strip( QString &message );

private:
  /// The webpage that is downloaded.
  QString page;
  
  /// The current type of translation being used.
  QString type;
  
  /// The current buddy that we are translating a message for.
  QString currentBuddy;

  /// The text that is currently being attempted to translate
  QString currentAttempt;

  /// Whether we are going in or out.
  int currentIn;

};

#endif

// babel.h

