/***************************************************************************
                             kinkattaplugin.h
                             -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTACHATPLUGIN_H
#define KINKATTACHATPLUGIN_H

#include <kinkattaplugin.h>
#include <qlist.h>
#include <qtoolbutton.h>
#include <qpixmap.h>

class Chat;

/**
 * Brief description
 * @author Benjamin Meyer
 */
class KinkattaChatPlugin : public KinkattaPlugin {

Q_OBJECT
	
signals:

public:
  /// Brief description.
  KinkattaChatPlugin(QWidget *parent=0, const char *name=0);
  
  /// Nothing significant.
  virtual ~KinkattaChatPlugin();

public slots:
  /// Brief description
  virtual void inChatMessage( QString buddy, QString message, bool isAuto ) = 0;
  virtual void outChatMessage( QString buddy, QString message, bool isAuto, bool endIdleNess ) = 0;
  virtual void initPlugin();

private slots:
  virtual void chatWindowCreated(Chat *window);
  virtual void distroyingChatWindow(Chat *window);

protected:
  QList<Chat> windows;
  QList<QToolButton> buttons;
  QPixmap image;
  ///
  void makeToolButton(Chat *window,QString text);

};

#endif

// KinkattaChatPlugin.h

