// $Id: jogshuttle.h,v 1.2 2001/08/05 07:33:32 ddennedy Exp $

/*
 * Copyright (C) 2001 Tomoaki Hayasaka <hayasakas@postman.riken.go.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef JOGSHUTTLE_H
#define JOGSHUTTLE_H

#include <gnome.h>

class JogShuttle
{
public:
  JogShuttle(GtkWidget *mainWindow);
  ~JogShuttle();
protected:
  friend void JogShuttle_inputCallback(gpointer data, gint source, GdkInputCondition condition);
  void inputCallback(gint source, GdkInputCondition condition);
private:
  void jog(int dir);
  void shuttle(int angle);
  void button(int code);

  GtkWidget *mainWindow_;
  int input_;
  gint monitorTag_;
};

#endif
