/*
 * page_edit.h Notebook Editor Page Object
 * Copyright (C) 2001 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _PAGE_EDITOR_H
#define _PAGE_EDITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "framedisplayer.h"
#include "kino_common.h"
#include "page.h"
#include "bar.h"
#include "preferences.h"

/** This class controls the editor notebook page.
*/

class PageEditor : public Page {
	private:
		// Common object
		KinoCommon *common;

		// GUI Widgets
		FrameDisplayer *displayer;
		Bar *bar;
		GtkDrawingArea *frameArea;
		GtkHScale *frameScale;
		GtkDrawingArea *barArea;
		GtkLabel *positionLabel;

		// State retention
		int lastFrameShown;
		gint idleCommand;
		gboolean idleCommandActive;

		// Playlist for holding the last copy/cut frames
		PlayList *g_copiedPlayList;

	public:
		PageEditor( KinoCommon *common );
		virtual ~PageEditor();
		FrameDisplayer *getFrameDisplayer() {
			return this->displayer;
		}
		// Overridden virtuals from Page
		gulong activate();
		void newFile();
		void start();
		void clean();
		gboolean processKeyboard( GdkEventKey *event );
		gboolean processCommandLine( char * );
		gboolean processMenuCommand( char * );
		void selectScene( int );
		void videoStartOfMovie();
		void videoPreviousScene();
		void videoStartOfScene();
		void videoRewind();
		void videoBack();
		void videoPlay();
		void videoForward();
		void videoFastForward();
		void videoShuttle( int );
		void videoNextScene();
		void videoEndOfScene();
		void videoEndOfMovie();
		void videoPause();
		void videoStop();

		void startNavigator();
		void stopNavigator();

		void movedToFrame( int frame );

		void showFrame( int, gboolean );
		void showFrame( int, Frame );
		
		void view50percent();
		void view100percent();
		void windowChanged();
		void windowMoved();
		void showFrameInfo( int );
		void saveFrame();

    	void InitBar( int currentFrame ) {
        	if (bar == NULL) bar = new Bar;
        	bar->Init( common->getPlayList() );
        	bar->Draw(GTK_WIDGET(frameScale), currentFrame);
    	}

    	void DrawBar(int currentFrame) {
        	if (bar == NULL) {
            	bar = new Bar;
        		bar->Init( common->getPlayList() );
        	}
        	bar->Draw(GTK_WIDGET(frameScale), currentFrame);
    	}

    	void ResetBar() {
        	if (bar) delete bar;
        	bar = new Bar;
        	bar->Init( common->getPlayList() );
        	bar->Draw(GTK_WIDGET( frameScale ), -1);
    	}

		void RefreshBar( int currentFrame ) {
			if (bar != NULL) {
				bar->Refresh( GTK_WIDGET(frameScale), currentFrame );
			}
		}

		vector <int> GetScene() {
			if ( bar == NULL )
				bar = new Bar;
			return bar->GetScene();
		}
	protected:
		gboolean processKeyboardCommand( char *cmd );
		void CopyFrames( int, int );
		void PasteFrames( int );
		void DeleteFrames( int, int );
};

#endif
