/*
 * page_export.h Notebook Firewire/AVI/Still Frame Export Page Object
 * Copyright (C) 2001 Dan Dennedy <dan@dennedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _PAGE_EXPORT_H
#define _PAGE_EXPORT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>

#include "kino_common.h"
#include "page.h"
#include "export.h"

// Forward references to page classes.
class Export;
class Export1394;
class ExportAVI;
class ExportStills;
class ExportAudio;


/** This class controls the Export notebook page.
*/

class PageExport : public Page {
	private:
		KinoCommon			*common;
		GtkNotebook			*notebook;
		GtkProgressBar		*progressBar;
		int					 currentMode;
		Export1394			*export1394;
		ExportAVI			*exportAVI;
		ExportStills		*exportStills;
		ExportAudio			*exportAudio;

	public:
		bool				 isExporting;
		bool				 exportMutex;

		PageExport( KinoCommon *common );
		virtual ~PageExport();
		gulong activate();
		void start();
		void clean();
		GtkWidget *getWidget();
		
		// Mode related functions
		void changeModeRequest( int mode );
		void setCurrentMode( int mode );
		Export *getCurrentPage();
		Export *getPage( int mode );

		// Accessors for each [predefined] export page
		Export1394 *getPageExport1394();
		ExportAVI *getPageExportAVI();
		ExportStills *getPageExportStills();
		ExportAudio *getPageExportAudio();

		// commands from the page interface
		gboolean processKeyboard( GdkEventKey *event );
		void view50percent();
		void view100percent();
		void selectScene( int );
		
		// commands defined by this interface
		void startExport();
		void stopExport();
	    void updateProgress( gfloat val );
	    void resetProgress();

protected:
		gboolean processKeyboardCommand( char *cmd );
		
};

#endif

