/*
 * page_export_1394.h Notebook Firewire/AVI/Still Frame Export Page Object
 * Copyright (C) 2001 Dan Dennedy <dan@dennedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _PAGE_EXPORT_1394_H
#define _PAGE_EXPORT_1394_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>

#include "export.h"
#include "page_export.h"
#include "ieee1394io.h"


/** This class represents the Export/IEEE 1394 notebook page.
*/

class Export1394 : public Export {
	private:
		KinoCommon	*common;
		GtkToggleButton	*previewButton;
		GtkEntry		*entry_cip_n;
		GtkEntry		*entry_cip_d;
		GtkEntry		*entry_syt_offset;
		IEEE1394Reader *exportReader;
		IEEE1394Writer *exportWriter;
		
	public:
		Export1394( PageExport*, KinoCommon* );
		virtual ~Export1394();

		gulong activate();
		void start();
		void clean();

		/* methods from the Export interface */
		void startExport();
		void stopExport();
		
		/* custom methods */
		void previewExport();
		
	private:
		void doExport();
};

#endif

