// Extract a GPS coordinates dump and list it

#include <stdio.h>
#include <stdint.h>
#include "gpsdump.h"

FILE *dumpf;
vector<net_hdr> net_vec;

int main(int argc, char *argv[]) {

    if (argc < 2) {
        fprintf(stderr, "FATAL:  Must provide dump file name.\n");
        exit(1);
    }

    if ((dumpf = fopen(argv[1], "rb")) == NULL) {
        fprintf(stderr, "FATAL:  Could not open dump file %s\n",
                argv[1]);
        exit(1);
    }

    file_hdr filhdr;

    if (fread(&filhdr, sizeof(file_hdr), 1, dumpf) < 1) {
        fprintf(stderr, "FATAL:  Could not read header.\n");
        exit(1);
    }

    printf("Got header version %d\n", filhdr.version);

    net_hdr nethdr[254];
    if (fread(&nethdr, sizeof(net_hdr), 254, dumpf) < 254) {
        fprintf(stderr, "FATAL:  Could not read network headers.\n");
        exit(1);
    }

    for (int x = 0; x < 254; x++) {
        net_vec.push_back(nethdr[x]);

        /*
        printf("Network %d %2x:%2x:%2x:%2x:%2x:%2x\n",
               nethdr[x].number,
               nethdr[x].bssid[0], nethdr[x].bssid[1], nethdr[x].bssid[2],
               nethdr[x].bssid[3], nethdr[x].bssid[4], nethdr[x].bssid[5]);
               */
    }

    net_hdr tracker_net;
    tracker_net.number = 0xFF;
    snprintf((char *) tracker_net.ssid, SSID_SIZE, "GPS PATH LOG");
    memset(tracker_net.bssid, 0xFF, MAC_LEN);

    net_vec[0xFF] = tracker_net;

    data_pkt dpkt;

    while (fread(&dpkt, sizeof(dpkt), 1, dumpf) > 0) {
        float lat, lon, alt, spd;

        lat = (float) dpkt.lat + ((float) dpkt.lat_mant / 1000000);
        lon = (float) dpkt.lon + ((float) dpkt.lon_mant / 1000000);
        alt = (float) dpkt.alt + ((float) dpkt.alt_mant / 1000000);
        spd = (float) dpkt.spd + ((float) dpkt.spd_mant / 1000000);

        printf("Got location for network %d ('%s' %02X:%02X:%02X:%02X:%02X:%02X) lat %f lon %f alt %f spd %f fix %d\n",
               dpkt.number,
               net_vec[dpkt.number].ssid,
               net_vec[dpkt.number].bssid[0], net_vec[dpkt.number].bssid[1],
               net_vec[dpkt.number].bssid[2], net_vec[dpkt.number].bssid[3],
               net_vec[dpkt.number].bssid[4], net_vec[dpkt.number].bssid[5],
               lat, lon, alt, spd, dpkt.fix);
    }

}


