#include <config.h>

#include <jni.h>

#ifdef COLTRANE

#include "Coltrane.h"


#include <X11/Xlib.h> // Every Xlib program must include this
#include <assert.h>   // I include this to test return values the lazy way
#include <unistd.h>   // So we got the profile for 10 seconds

JNIEXPORT void JNICALL Java_pygmalion_Toolkit_xlib_init(JNIEnv* env, jobject o)
{
  int blackColor;
  int whiteColor;
  Window w;
  GC gc;

      // Open the display
	   
      Display *dpy = XOpenDisplay(NULL);
      assert(dpy);

      // Get some colors

      blackColor = BlackPixel(dpy, DefaultScreen(dpy));
      whiteColor = WhitePixel(dpy, DefaultScreen(dpy));

      // Create the window

      w = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy), 0, 0, 
                                     200, 100, 0, blackColor, blackColor);

      // We want to get MapNotify events

      XSelectInput(dpy, w, StructureNotifyMask);

      // "Map" the window (that is, make it appear on the screen)

      XMapWindow(dpy, w);

      // Create a "Graphics Context"

      gc = XCreateGC(dpy, w, 0, NULL);

      // Tell the GC we draw using the white color

      XSetForeground(dpy, gc, whiteColor);

      // Wait for the MapNotify event
	{
			for(;;) {
            XEvent e;
            XNextEvent(dpy, &e);
            if (e.type == MapNotify)
                  break;
			}

	}
      // Draw the line
      
      XDrawLine(dpy, w, gc, 10, 60, 180, 20);

      // Send the "DrawLine" request to the server

      XFlush(dpy);

      // Wait for 10 seconds

//      sleep(10);
  
  return;
}

JNIEXPORT jint JNICALL Java_pygmalion_Toolkit_xlib_get_event(JNIEnv* env, jobject o)
{

  return 0;
}

#endif
