class EtherPacket extends Packet
{
  HWAddr dest; 		// The source hardware address (MAC)
  HWAddr src;  		// The destination hardware address
  public int HEADER_LEN = 14;
  
  /**********************************
   * See comments in HWAddr.java ...*
   **********************************/
   
  EtherPacket()
  {
    dest=null;
    src=null;
    data=null;
  }

  EtherPacket (Packet p)
  {
    data=p.data;
    parse();
  }
  
  EtherPacket(byte[] raw)
  {
    data = raw;
    parse();
  }
  
  void parse()
  {
    dest = new HWAddr(data[0],data[1],data[2],data[3],data[4],data[5]);
    src = new HWAddr(data[6],data[7],data[8],data[9],data[10],data[11]);
    protocol = (data[12] << 8) + data [13]; // Network order: Big Endian
  }
  
  void setSrcDestProt(HWAddr src, HWAddr dest,int protocol)
  {
    this.src=src;
    this.dest=dest;
    this.protocol=protocol;
    update();
  }

  public void update()
  {
    System.arraycopy(dest.getData(),0,data,0,6);
    System.arraycopy(src.getData(),0,data,6,6);
    data[12]=(byte)(protocol >> 8);
    data[13]=(byte)(protocol & 255);
  }
  
  public String toString()
  {
    return src.toString()+"-->>"+dest.toString();
  }
};

