abstract class NetworkInterface extends Thread
{
  protected boolean hasARP; 	// Does it use ARP?
  protected boolean up;		// Is the interface up?
  protected IPAddr ipaddr;
  protected IPAddr netmask;
  protected IPAddr broadcast; 
  protected Protocol firstProtocol;

  abstract public boolean init();
  abstract Packet readPacket();
  abstract void writeIPPacket(IPPacket ipp);
  abstract void writePacket(Packet P,HWAddr src,HWAddr dest,int protocol);
  
  NetworkInterface()
  {
    up = false;
    firstProtocol = null;	
  }
  
  public void setIPAddr(IPAddr ipaddr)
  {
    this.ipaddr=ipaddr;
  }
  
  public void addProtocol(Protocol p)
  {
    if (firstProtocol == null)
    { firstProtocol = p; }
    else 
    {
      p.setNextProtocol(firstProtocol);
      firstProtocol = p;
    }
  }
  
  public boolean up()
  {
    start();
    return true;
  }

  public void down()
  {
    up=false;
  }
  
  public void run()
  {
    up=true;
    demux();
  }
  
  protected void demux()
  {
    System.out.println("Demuxing!");
    boolean handled;
    Protocol currentProtocol;
    Packet p;
    while (up)
    {
      System.out.println("Before readpacket");
      p = readPacket();
      System.out.println("After readpacket");
      handled = false;
      currentProtocol = firstProtocol;
      while ((currentProtocol != null) && !handled)
      {
        if (currentProtocol.getProtocolNumber() == p.protocol)
	{
	  currentProtocol.Handle(p);
	  handled = true;
	}
	currentProtocol=currentProtocol.getNextProtocol();
      }
      if (!handled) {System.out.println("Unknown Proto: "+p.protocol);}
    }
  } 
}


