/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "jni.h"

jbyte jos_system_machine_in8(  JNIEnv* env, jclass clazz, short port);
jchar jos_system_machine_in16(  JNIEnv* env, jclass clazz, short port);
jint jos_system_machine_in32(  JNIEnv* env, jclass clazz, short port);

void jos_system_machine_out8(  JNIEnv* env, jclass clazz, short port, jbyte value);
void jos_system_machine_out16(  JNIEnv* env, jclass clazz, short port, jchar value);
void jos_system_machine_out32(  JNIEnv* env, jclass clazz, short port, jint value);

jchar jos_system_machine_read8(  JNIEnv* env, jclass clazz, jint address);
int16 jos_system_machine_write8(  JNIEnv* env, jclass clazz, jint address, jchar value);
jint jos_system_machine_read16(  JNIEnv* env, jclass clazz, jint address);
jint jos_system_machine_write16(  JNIEnv* env, jclass clazz, jint address, jint value);

jint jos_system_machine_read32(  JNIEnv* env, jclass clazz, jint address);
jint jos_system_machine_write32(  JNIEnv* env, jclass clazz, jint address, jint value);


void jos_system_machine_printk(JNIEnv* env, jclass class, jstring str);
//void jos_system_machine_testSVGA(JNIEnv* env,jclass clazz );
void jos_system_machine_freeSystemHeap(JNIEnv* env, jclass clazz);
