/*
 * HeaderParser.java
 *
 * Created on April 4, 2001, 11:48 PM
 */

import java.io.*;
import java.util.*;
/**
 *
 * @author  root
 * @version 
 */
public class HeaderParser extends Object {

    private int state;
    private final static int FIND_CLASS = 1;
    private final static int FIND_METHOD = 2;
    private final static int FIND_SIGNATURE = 3;
    private final static int FIND_FUNCTION = 4;
    Vector entries = new Vector();
    
    
    /** Creates new HeaderParser */
    public HeaderParser() {
    }
    public void parseReader(Reader r){
        String workingString = null;
        ClassEntry currentEntry = new ClassEntry();
        BufferedReader reader = new BufferedReader(r);
        state = FIND_CLASS;
        try{
            while((workingString = reader.readLine())!=null)
                switch (state) {
                    case FIND_CLASS:
                        if(workingString.indexOf("Class:")>=0){
                            currentEntry.setClazz(parseValue(workingString).replace('_','/'));
                            state=FIND_METHOD;
                        }
                        break;
                    case FIND_METHOD:
                        if(workingString.indexOf("Method:")>=0){
                            //parseClass()
                            currentEntry.setMethod(parseValue(workingString));
                            state=FIND_SIGNATURE;
                        }
                        break;
                    case FIND_SIGNATURE:
                        if(workingString.indexOf("Signature:")>=0){
                            //parseClass()
                            currentEntry.setSignature(parseValue(workingString));
                            state=FIND_FUNCTION;
                        }
                        break;
                    case FIND_FUNCTION:
                        if(workingString.indexOf("Java_")>=0){
                            //parseClass()
                            currentEntry.setFunction(parseFunction(workingString));
                            entries.add(currentEntry);
                            currentEntry = new ClassEntry();
                            state=FIND_CLASS;
                        }
                        break;
                    default:
                        System.out.println("INVALID STATE OCCURRED");
                        break;
                }
                            
        }catch(IOException ioe){
            System.out.println("IOException occured:"+ioe.getMessage());
        }
    }
    private String parseValue(String s){
        StringTokenizer tokenizer = new StringTokenizer(s," ");
        while(tokenizer.hasMoreElements()){
            if(tokenizer.nextToken().indexOf(":")>0){
                return tokenizer.nextToken();
            }
        }
		return null;
	}
    private String parseFunction(String s){
		String ret = null;
		int index = s.indexOf("Java_");
		int index2 = s.indexOf(")");
		// NEED TO CHECK THIS
		if(index2>=0){
			ret = s.substring(index,index2);
		}else{
			ret = s.substring(index);
		}
		return ret;
	}
    public void dumpEntries(){
        Enumeration e = entries.elements();
        while(e.hasMoreElements()){
            System.out.println(((ClassEntry)e.nextElement()).formatFunctionTableEntry());
        }
    }
    private static void main(String[] args){
        HeaderParser parser = new HeaderParser();
        try{
            Reader r = new FileReader(args[0]);
            parser.parseReader(r);
            parser.dumpEntries();
        }catch(IOException ioe){
            System.out.println("IOException occurred in main:"+ioe.getMessage());
        }
    }
}
