/*
 * @doc MODULE
 * @module opcodes.h |
 *
 * List of opcodes for the interpreter
 *
 */

#ifndef __OPCODES_H__
#define __OPCODES_H__

/* enum of all the Java opcodes *******************************************/

/*
 * @doc TYPE
 * @type tJavaOpCode | Enumeration of all the opcodes of the Java bytecode
 *                     instructions.
 *
 */

typedef enum tjavaopcode
{
  /* nop */

  nop,

  /* pushing constants */

  aconst_null,
  iconst_m1,
  iconst_0,
  iconst_1,
  iconst_2,
  iconst_3,
  iconst_4,
  iconst_5,
  lconst_0,
  lconst_1,  /* 10 */
  fconst_0,
  fconst_1,
  fconst_2,
  dconst_0,
  dconst_1,
  bipush,
  sipush,
  ldc1,
  ldc2,
  ldc2w,     /* 20 */

  /* loading local variables */

  iload,
  lload,
  fload,
  dload,
  aload,
  iload_0,
  iload_1,
  iload_2,
  iload_3,
  lload_0,   /* 30 */
  lload_1,
  lload_2,
  lload_3,
  fload_0,
  fload_1,
  fload_2,
  fload_3,
  dload_0,
  dload_1,
  dload_2,   /* 40 */
  dload_3,
  aload_0,
  aload_1,
  aload_2,
  aload_3,

  /* loading array elements */

  iaload,
  laload,
  faload,
  daload,
  aaload,    /* 50 */
  baload,
  caload,
  saload,

  /* storing to local variables */

  istore,
  lstore,
  fstore,
  dstore,
  astore,
  istore_0,
  istore_1,  /* 60 */
  istore_2,
  istore_3,
  lstore_0,
  lstore_1,
  lstore_2,
  lstore_3,
  fstore_0,
  fstore_1,
  fstore_2,
  fstore_3,  /* 70 */
  dstore_0,
  dstore_1,
  dstore_2,
  dstore_3,
  astore_0,
  astore_1,
  astore_2,
  astore_3,

  /* storing to array elements */

  iastore,
  lastore,   /* 80 */
  fastore,
  dastore,
  aastore,
  bastore,
  castore,
  sastore,

  /* stack instructions */

  pop,
  pop2,
  dup_,
  dup_x1,    /* 90 */
  dup_x2,
  dup2_,
  dup2_x1,
  dup2_x2,
  swap,

  /* arithmetic instructions */

  iadd,
  ladd,
  fadd,
  dadd,
  isub,      /* 100 */
  lsub,
  fsub,
  dsub,
  imul,
  lmul,
  fmul,
  dmul,
  idiv,
  ldiv_,
  fdiv,      /* 110 */
  ddiv,
  imod,
  lmod,
  fmod_,
  dmod,
  ineg,
  lneg,
  fneg,
  dneg,

  /* logical instructions */

  ishl,      /* 120 */
  lshl,
  ishr,
  lshr,
  iushr,
  lushr,
  iand,
  land,
  ior,
  lor,
  ixor,      /* 130 */
  lxor,

  /* increment */

  iinc,

  /* conversion operations */

  i2l,       /* 133 here... was 132 in spec */
  i2f,       /* 134 here... was 133 in spec */
  i2d,       /* 135 here... was 134 in spec */
  l2i,
  l2f,
  l2d,
  f2i,
  f2l,       /* 140 */
  f2d,
  d2i,
  d2l,
  d2f,
  int2byte,
  int2char,
  int2short,

  /* comparision instructions */

  lcmp,
  fcmpl,
  fcmpg,     /* 150 */
  dcmpl,
  dcmpg,

  /* branch instructions */

  ifeq,
  ifne,
  iflt,
  ifge,
  ifgt,
  ifle,
  if_icmpeq,
  if_icmpne, /* 160 */
  if_icmplt,
  if_icmpge,
  if_icmpgt,
  if_icmple,
  if_acmpeq,
  if_acmpne,
  goto_,
  jsr,
  ret,

  /* table jumping */

  tableswitch, /* 170 */
  lookupswitch,

  /* function return */

  ireturn,
  lreturn,
  freturn,
  dreturn,
  areturn,
  return_,

  /* manipulating object fields */

  getstatic,
  putstatic,
  getfield, /* 180 */
  putfield,

  /* method invocation */

  invokevirtual,
  invokespecial,  /* was nonvirtual,*/
  invokestatic,
  invokeinterface,

  /* miscellaneous object operations */

  newfromname,
  new_,
  newarray,
  anewarray,
  arraylength, /* 190 */
  athrow,
  checkcast,
  instanceof,

  /* monitors */

  monitorenter,
  monitorexit,

  wide,
  /* debugging 

     I don't know what this verify stack thing is! But 196 should be wide.
  verifystack,*/
/*  breakpoint,*/  /* breakpoint is in the documentation, but the compiler
                      does not use it... multianewarray moves up one place
                      to take breakpoint's place */

  /* more arrays */

  multianewarray,

  /* undocumented java class stuff */
  ifnull,
  ifnonnull,

  /* optimisations */
  ldc1_quick, /*200*/
  ldc2_quick,
  ldc2w_quick,

  getfield_quick,
  putfield_quick,
  getfield2_quick,
  putfield2_quick,

  /* These are short-cuts when the current class is not the same as the static field's class */
  getstatic_quick,
  putstatic_quick,
  getstatic2_quick,
  putstatic2_quick, /* +- 210 */

  invokevirtual_quick,
  invokespecial_quick, /* was nonvirtual */
  invokestatic_quick,
  invokeinterface_quick,
  invokevirtualobject_quick,     /* ???? I can't understand this !!!! */

  new_quick,
  anewarray_quick,
  checkcast_quick,
  instanceof_quick,

  /* shortcuts for when the current class is the same as the static field's
     class */
  putstaticcurrclass_quick, /* +- 220 */
  putstatic2currclass_quick,
  getstaticcurrclass_quick,
  getstatic2currclass_quick,

  invokenonvirtualcurrclass_quick,
  invokestaticcurrclass_quick,

  /* used for preloaded classes in ROM because we can't overwrite the operand
     with a guess */
  invokeinterface_noguess, /* +- 226 */

  /* Special instructions to invoke optimised methods */
  invokevirtual_quick_optimised

} tJavaOpCode;

#endif

/* end of opcodes.h */
