#ifdef USE_DISTRIBUTED_STORE


#include <pthread.h>
#include "storemanager.h"
#include "store_communication.h"

#include <assert.h>
#include "gamma.h"



/*Start lock service*/

int initialized_lock_service = 0;

/*Global variables for all threads*/

char remoteHost[] = "svetlana";
int sequence = 555;

int get_free_block(struct thread_context* context)
{
    //Has to find a free block for an object entry
    return context->free_object_entry++;
}

void mark_block_as_used(int bn, struct thread_context *context)
{
  //Read from allocation bitmap
  //Allocation bitmap lives at 1 TB
  byte readval = 0;
  int success;
  int i;
  long long address = 0x100000000000L; //1 TB
  int offset;

#ifdef DEBUG_PROXY
  printf("mark_block_as_used, about to read sequence %i\n", sequence + 1);
#endif
  offset = ( bn / 8 );

  assert(offset >= 0);
 assert(offset < BLOCK_SIZE);
  success = GAMMA_read( address, &readval, offset, sizeof(readval));
  assert(offset >= 0);
  if(success == -1)
    {
      printf("-|-|-| Read failed, assuming 0\n");
      readval = 0;
    }
  //Set relevant bit

#ifdef DEBUG_PROXY
  printf("Readval before %x\n", readval);
#endif

  readval = readval | ( 2 << (offset % 8));

#ifdef DEBUG_PROXY
  printf("Readval after %x\n", readval);
#endif
  //Write back to allocation bitmap

  success = GAMMA_write( address, &readval, offset, sizeof(readval));

  if(success == -1 )
    {
      printf("mark_block_as_used failed\n");
    }
}

void write_object_entry(long long address, int offset, int* payload, struct thread_context* context);

void create_object_entry(int bn, int objsize, int numblocks, struct thread_context *context)
{
    long long address;
    int i;
    int offset;
    int* payload = (int*) malloc(512);

    for(i = 0; i < (512 / sizeof(int));i++)
	{
	    payload[i] = 0;
	}
    payload[0] = bn;
    payload[1] = objsize;
    payload[2] = 0; //Small object
    payload[3] = numblocks;

if(numblocks == 0)
    {
    printf("Num blocks is 0!!!!!!!!\n");
    exit(888);
    }
else
    {
	//	printf("--- There are %i blocks\n", numblocks);
    }
    for(i = 0; i < numblocks;i++)
     payload[4 + i] = context->free_data_block++;

    //    printf("Writing pid %x to block number %i\n", -bn, payload[4]);

    address = 0x400000000000L + bn * 512;
    offset = address % BLOCK_SIZE;
    write_object_entry(address - offset, offset, payload, context);
}

void write_object_entry(long long address, int offset, int* payload, struct thread_context* context)
{
  int success =   GAMMA_write(address, (void*) payload, offset, 512);
  if(success == -1)
    {
      printf("write_object_entry FAILED %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
    }
  else
    {
#ifdef DEBUG_PROXY
      printf("write_object_entry wrote to address \n");
#endif
    }
    free(payload);
}

void proxy_new_object(int fd, struct proxy_command *command, void* buffer, struct thread_context *context)
{
  int objsize;
  int num_blocks = 0;
  int block_number = 0;


  //  printf("proxy_new_object about to get free block\n"); 
  block_number = get_free_block(context);

  assert(block_number >= 0);

  //  printf("proxy_new_object did get free block\n"); 
  //  FILE* log ;
  //  char logbuf[256];

  read(fd, &objsize, sizeof(objsize));

  assert(objsize >= 0);
    //Check that there is a free block in allocation bitmap

    if(block_number == -1)
	{
	    printf("Could not get free block!\n");
	    exit(2);
	}
    else
	{

	}

    mark_block_as_used( block_number, context );

    //Calc how many blocks
    num_blocks = objsize / (int) BLOCK_SIZE;
    if((objsize % BLOCK_SIZE) == 0)
	num_blocks += 0;
    else
	num_blocks += 1;

    //    printf("objsize %i, block_size %i, blocks %i, %i\n", objsize, (int) BLOCK_SIZE, num_blocks, objsize / BLOCK_SIZE);

    create_object_entry(block_number, objsize, num_blocks, context);

    

    


    block_number = -block_number;

#ifdef DEBUG_PROXY
  /*Write to a log every new object we create */
    /*  log = fopen("newobject.log", "a+");
  sprintf(logbuf, "%x size %i\n", block_number, objsize);
  fwrite(logbuf, strlen(logbuf), 1, log);
  fclose(log);*/
#endif

    write(fd, &block_number, sizeof(int));



#ifdef DEBUG_PROXY
    printf("Creating new object %x (%i bytes)\n", block_number, objsize);
#endif
 
}

static int BUFFER_SIZE = 65 * 1024; 



void proxy_shutdown(struct thread_context *context)
{
  long long address;
  int success;
  int i, j;
  int* buf = (int*) malloc(512);
  
  /*Try and write last highest object*/
  
  address = 0x2000L;

  buf[0] = context->free_object_entry;
  buf[1] = context->free_data_block;

  
  success = GAMMA_write(address, buf, 0, sizeof(int) * 2);
    if(success == -1)
      {
	printf("------------------------ proxy_shutdown Could not write free_object_entry ----------------------\n");
      }



	    printf("*proxy_shutdown flushing gamma\n");
	    GAMMA_flush(0L, 0x600000000000L);
	    printf("*proxy_shutdown finished\n");
}
void proxy_init(struct proxy_command *command, struct thread_context* context)
{
  long long address;
  int success;
  int i, j;
  int* buf = (int*) malloc(512);


  assert(buf != NULL);
  /*Set locks off */
  	    context->low_object_entry_lock = -1;
	    context->high_object_entry_lock = -1;

  /*Try and read last highest object*/
  
  address = 0x2000L;

  #ifdef DEBUG_PROXY
  printf("proxy_init reading from GAMMA\n");
  #endif
  success = GAMMA_read(address, buf, 0, sizeof(int) * 2);
    if(success == -1)
      {
  #ifdef DEBUG_PROXY
  printf("proxy_init read -1!\n");
  #endif
	context->free_object_entry = 1;
      }
    else
	{
  #ifdef DEBUG_PROXY
  printf("proxy_init got old free_object_entry %i, block %i\n", buf[0], buf[1]);
  #endif
  assert(buf[0] >= 0);
  assert(buf[1] >= 0);
	    context->free_object_entry = buf[0];
	    context->free_data_block = buf[1];
	}
  free(buf);
}



void proxy_load_object(int fd, struct proxy_command *command, void* buffer, struct thread_context* context)
{
  PID pid;
  int objsize;
  int* buf = (int*) malloc(512);
  long long address;
  long long lock_address;
  char* mem;
  int success;
  int offset; //Offset within the page we want to read
  read(fd, &pid, sizeof(pid));


#ifdef DEBUG_PROXY
  printf("Store manager: load object, pid %x\n", pid);
#endif

  /*We first need to lock the allocation bitmap part for this objects entry */


  //The bitmap is here 
  lock_address = 0x100000000000L;

  //And this bit is at this byte
   lock_address += ( (-pid) / 8 );

   //Which is in this 4k block

    //We first need to read the object entry, so lets calculate where that would be
    address = 0x400000000000L + ((-pid) * 512);
    offset = (address % BLOCK_SIZE);

#ifdef DEBUG_PROXY
	printf("proxy_load_object address %x %x, offset %i\n", (int) (address >> 32), (int) ((address << 32) >> 32), offset);
#endif

    success = GAMMA_read(address - offset, buf, offset, 512);
    if(success == -1)
      {
	printf("proxy_load_object failed ot read objsize\n");
	exit(22);
      }
    else
      {
	/* Find the object size */
	int numblocks = buf[3];
	int i = 0;
	int j = 0;
	objsize = buf[1];

	assert(buf[0] != 0);
#ifdef DEBUG_PROXY
	printf("(load) Object entry for %x is: size %i, blocks %i\n", buf[0], buf[1], buf[3]);
#endif
	write(fd, &objsize, sizeof(objsize));

#ifdef DEBUG_PROXY
  printf("load_object reading %i bytes\n", objsize);
#endif


    if(objsize > BUFFER_SIZE)
      mem = (char*) malloc(objsize);
        else 
      mem = buffer;

  /* Now we have to read each block */

	for(i = 0; i < numblocks; i++)
	  {
	    int about_to_read = 4096;
	    address = 0x500000000000L + buf[4 + i] * 4096;
#ifdef DEBUG_PROXY
	printf("(load) reading block at %x %x\n", (int) (address >> 32), (int) ((address << 32) >> 32));
#endif
	    if(objsize < ((i+1) * 4096))
	      about_to_read = objsize % 4096;

#ifdef DEBUG_PROXY	    
	    printf("load_object About to read %i bytes from alpha\n", about_to_read);
#endif

	    success = GAMMA_read(address, mem + (i * 4096), 0, about_to_read);
	    if(success == -1)
	      {
		printf("load_object read failed ************\n");
		exit(2);
 	      }

#ifdef DEBUG_PROXY_WITH_DUMP
	    printf("proxy_load_object dumping object %x\n", pid);
	    for(j = 0; j < (about_to_read / 4);j++)
		printf("%x", *((int*) (mem + (i * 4096) + j * 4)));
	    printf("\n");
#endif
	  }

	
#ifdef DEBUG_PROXY
        printf("load_object About to write %i bytes to proxy\n", objsize);
#endif
	success = write(fd, mem, objsize);

	if(success != objsize)
	    {
		printf("load_object (data) wrote %i bytes, should have been %i\n", success, objsize);
		exit(77);
	    }

	if(objsize > BUFFER_SIZE)  
	    free(mem);

      }
}

void proxy_update_object(int fd, struct proxy_command *command, void* buffer, struct thread_context* context)
{
  PID pid;
  int objsize;
  char* mem;
  int amount;
  long long address;
  int success;
  int offset;
  int* buf = (int*) malloc(512);
  assert(buf != NULL);
  amount = read(fd, &pid, sizeof(pid));
  assert(amount == sizeof(pid));
#ifdef DEBUG_PROXY
    printf("Store manager: update object, pid %x\n", pid);
#endif

    /* Find the object size */
    
//We first need to read the object entry, so lets calculate where that would be
    address = 0x400000000000L + ((-pid) * 512L);
    offset = (address % BLOCK_SIZE);

#ifdef DEBUG_PROXY
	printf("proxy_load_object address %x %x, offset %i\n", (int) (address >> 32), (int) ((address << 32) >> 32), offset);
#endif

    success = GAMMA_read(address - offset, buf, offset, 512);
    assert(success != -1);
    if(success == -1)
      {
	printf("proxy_update_object failed to read objsize\n");
	exit(55);
	printf("did we exit?????????????\n");
      }
    else
      {

	int numblocks = buf[3];
	
	int i = 0;
	int j = 0;
if(numblocks < 0)
    printf("There are %i numblocks!\n", numblocks); 
	assert(numblocks >= 0);
	assert(buf[0] != 0);
	objsize = buf[1];

#ifdef DEBUG_PROXY
	printf("Object entry for  %x is: size %i, blocks %i\n", buf[0], buf[1], buf[3]);
#endif

	assert(objsize > 0);
 amount = write(fd, &objsize, sizeof(objsize));
 assert(amount == sizeof(objsize));

  if(objsize > BUFFER_SIZE)
      mem = (char*) malloc(objsize);
  else 
      mem = buffer;
  assert(mem != NULL);
  amount = read(fd, mem, objsize);

  if(amount != objsize)
      {

	  //Attempt to read the rest
	  int left = objsize - amount;
	  assert(amount >= 0);
	  printf("Failed to read bytes in update_object %i %i\n", amount, objsize);
	  while(left > 0)
	      {
		  amount = read(fd, mem + (objsize - left) , left);
		  assert(amount >= 0);
		  left -= amount;
		  printf("Reading in increments, just read %i, left %i\n", amount, left);
	      }
	  printf("succeeded to read bytes in update_object %i %i\n", amount, objsize);
      }

	//Now write each block
	for(i = 0; i < numblocks; i++)
	  {
	    int about_to_write = 4096;
	    address = 0x500000000000L + buf[4 + i] * 4096;
	    if(objsize < ((i+1) * 4096))
	      about_to_write = objsize % 4096;

#ifdef DEBUG_PROXY_WITH_DUMP	    
	    printf("update_object_entry About to write %i bytes\n", about_to_write);
	    printf("proxy_update_object dumping object %x\n", pid);
	    for(j = 0; j < (about_to_write / 4);j++)
		printf("%x", *((int*) (mem + (i * 4096) + j * 4)));
	    printf("\n");
#endif

if( i == (numblocks - 1))
 success = GAMMA_write(address, mem + (i * 4096), 0, objsize - ((numblocks - 1) * BLOCK_SIZE)); //about_to_write); XXXXX 
else
 success = GAMMA_write(address, mem + (i * 4096), 0, about_to_write); //XXXXX 

	    if(success == -1)
	      {
		printf("update_object Write failed\n");
		exit(22);
	      }
	  }
      }


#ifdef DEBUG_PROXY
    printf("Store manager: update object, bytes %i\n", objsize);
#endif






  if(objsize > BUFFER_SIZE)

      free(mem);


}


void proxy_close_store(struct proxy_command *command)
{

}

void proxy_get_object_size(int fd, struct proxy_command *command, struct thread_context *context)
{
  PID pid;
  int objsize;
  long long address;
  int success;
  long long offset;
  int* buf = (int*) malloc(512);
  assert(buf != NULL);
  read(fd, &pid, sizeof(pid));

#ifdef DEBUG_PROXY
    printf("Store manager: get object size, pid %x\n", pid);
#endif

    /* Find the object size */
    
    //We first need to read the object entry, so lets calculate where that would be
    address = 0x400000000000L + ((-pid) * 512);
    offset = (address % BLOCK_SIZE);

#ifdef DEBUG_PROXY
	printf("proxy_get_object_size address %x %x, offset %i\n", (int) ((address) >> 32), (int) (((address)<< 32) >> 32), offset);
#endif
    success = GAMMA_read(address - offset, buf, offset, 512);
    if(success == -1)
      {
	printf("proxy_get_object_size failed ot read objsize 2\n");
	exit(52);
      }
    else
      {
	int numblocks = buf[3];
	int i = 0;
	assert(buf[0] != 0);
#ifdef DEBUG_PROXY	    
	printf("get_object_size Object entry for %x is: size %i, blocks %i, pid %x\n", buf[0], buf[1], buf[3], pid);
#endif

	objsize = buf[1];

	write(fd, &objsize, sizeof(objsize));

      }


#ifdef DEBUG_PROXY
  printf("Store manager: get object size, bytes %i\n", objsize);
#endif




}

void proxy_open_store(int fd, struct proxy_command *command)
{
  //We've already done this, so we do nothing
  printf("Store Manager: Open Store\n");
}



void proxy_get_root_pid(int fd, struct proxy_command *command, struct thread_context *context)
{
  PID pid;

/*We read the PID from a fixed address (currently)*/

long long address = 0x10000L;
int result;

result = GAMMA_read(address, (char*) &pid, 0, sizeof(pid));

if(result == -1)
{
      printf("proxy_get_root_pid: GOT NACK, there is no root\n");
      pid = 0;
}
else
  {
    printf("proxy_get_root_pid %x\n", pid);
  }

#ifdef DEBUG_PROXY
  printf("Store manager: get root pid %x\n", pid);
#endif
  write(fd, &pid, sizeof(pid));

  //  reply = (struct proxy_command*) malloc( sizeof(struct proxy_command) + sizeof(pid));
  //  *((PID*) &reply->data) = pid;
  //  write(fd, reply, sizeof(struct proxy_command) + sizeof(pid));

}

void proxy_set_root_pid(int fd, struct proxy_command* command, struct thread_context *context)
{
  PID pid;

  //We have to write an entry to address 0x10000L

    long long address = 0x10000L;
    int result;

    read(fd, &pid, sizeof(pid));

    fprintf(stderr, "set_root_pid %i, doing flush\n", sequence);
    result = GAMMA_write(address, &pid, 0, sizeof(pid));
    GAMMA_flush(0x10000L, 0x10000L);
if( result == -1)
  {
    printf("set_root_pid failed\n");
    exit(227);
  }
else 
  {
    printf("set_root_pid ok\n");
  }

}
 



#include <pthread.h>

int running_port = 26787;

void pinitialize_thread_context(struct thread_context *acontext)
{
    struct sockaddr_in to;

    to.sin_family = AF_INET;
    if(inet_aton("1.0.0.2", &to.sin_addr) == 0)
	{
	    perror("initialize_remote_socket");
	}


    acontext->free_object_entry = -1;
    acontext->free_data_block = 0;
    acontext->low_object_entry_lock = -1;
    acontext->high_object_entry_lock = -1;


    acontext->listen_thread_ready = 0;
    acontext->lock_listen_thread_ready = 0;

    acontext->our_id_host = to.sin_addr.s_addr;
    acontext->our_id_port = htons(9009);

    acontext->locking_socket = -1;
}


void service_proxy_thread(char** arg)
{
    int fd;
    pthread_t listen_t;
    struct proxy_command *command;
    struct thread_context context;
    int amt_read = 0;
    void* buffer;
  
    int finished = 0;
    int command_counter = 0;

    pthread_mutex_t mut = PTHREAD_MUTEX_INITIALIZER;

    fd = *((int*) arg);

    /*Initialize buffer !!!! */
    buffer = (void*) malloc (BUFFER_SIZE);



    if(buffer == NULL)
      {
	perror("Malloc failed in storemanager service_proxy_thread");
	printf("BUFFER_SIZE is %i\n", BUFFER_SIZE);
	exit(777);
      }
    pinitialize_thread_context(&context);
    context.mut = &mut;

    /*Initialize mutex*/
    pthread_mutex_init(context.mut, NULL);

    //    printf("testing id %i %i\n", context.our_id_host, context.our_id_port);


  printf("** All systems go \n");
    command = (struct proxy_command*) buffer;
  
while(finished == 0)
    {
    amt_read = read(fd, command, sizeof(struct proxy_command));
    assert(amt_read >= 0);
    while(amt_read < sizeof(struct proxy_command))
      {
	  int add = read(fd, ((char*) command) + amt_read, sizeof(struct proxy_command) - amt_read);
	  assert(add >= 0);
	  amt_read += add;
      }

	    if(amt_read != sizeof(struct proxy_command))
	      {
		printf("Error, couldn't read the whole command, read %i, should be %i\n", amt_read, sizeof(struct proxy_command));
		if(amt_read == -1)
		    {
		    perror("");
		    printf("Errno is %i, E_FAULT %i\n", errno, EFAULT);
		    }
		exit(254);
	      }


#ifdef DEBUG_PROXY	    
	    printf("%i: command is %i, amt read %i, intended %i, data %i, source_ip %i,  source_port %i\n", command_counter++, command->command, amt_read, sizeof(struct proxy_command), command->data_length, command->source_ip, command->source_port);
#endif	    
	    if(!(command->command > 0 && command->command <= 255))
	      {
		printf("Command out of range %i", command->command);
		exit(4);
	      }

	    command_counter++;



	    if(command->command == PROXY_COMMAND_SHUTDOWN)
	      {
		  proxy_shutdown(&context);
		  finished = 1;
		printf("*proxy_shutdown completed\n");
	      }
	    else
		{
		    if(context.free_object_entry != -1) {
		  assert(context.free_object_entry >= 0);
		    }
		switch(command->command)
		  {
		  case PROXY_COMMAND_INIT:
		   #ifdef DEBUG_PROXY
		    printf("*proxy_init\n");
		   #endif
		    proxy_init(command, &context);
		  break;
		  case PROXY_COMMAND_OPEN_STORE:
#ifdef DEBUG_PROXY
		    printf("*proxy_open_store\n");
 #endif
		    proxy_open_store(fd, command);
		    break;
		  case PROXY_COMMAND_GET_ROOT_PID:
#ifdef DEBUG_PROXY
		    printf("*proxy_get_root_pid\n");
 #endif
		    proxy_get_root_pid(fd,command, &context);
		    break;
		  case PROXY_COMMAND_GET_OBJECT_SIZE:
#ifdef DEBUG_PROXY
		    printf("*proxy_get_object_size\n");
 #endif
		    proxy_get_object_size(fd, command, &context);
		    break;
		  case PROXY_COMMAND_CLOSE_STORE:
#ifdef DEBUG_PROXY
		    printf("*proxy_close_store\n");
 #endif
		    proxy_close_store(command);
		  break;
		  case PROXY_COMMAND_LOAD_OBJECT:
#ifdef DEBUG_PROXY
		    printf("*proxy_load_object\n");
 #endif
		    proxy_load_object(fd, command, buffer, &context);
		  break;
		  case PROXY_COMMAND_UPDATE_OBJECT:
#ifdef DEBUG_PROXY
		     printf("*proxy_update_object\n");
 #endif
		    proxy_update_object(fd, command, buffer, &context);
		    break;
		  case PROXY_COMMAND_NEW_OBJECT:
#ifdef DEBUG_PROXY
		     printf("*proxy_new_object\n");
 #endif
		    proxy_new_object(fd, command, buffer, &context);
		    break;
		  case PROXY_COMMAND_SET_ROOT_PID:
#ifdef DEBUG_PROXY
		    printf("*proxy_set_root_pid\n");
 #endif
		    proxy_set_root_pid(fd, command, &context);

		    break;
		  default:
		    printf("invalid command\n");
		    exit(2);
		  }
	      }
    }
	close(fd);
	printf("Thread listening to proxy is shutting down, processed %i commands\n", command_counter);
}

void listen_for_proxy_thread(char** arg)
{
  int s;
  struct sockaddr_in sin;
  int len;
  int fd;
  int finished = 0;
  pthread_t service_tid;

  int connection_counter = 0;



	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = htons(PROXY_PORT);

	if(( s = socket(PF_INET, SOCK_STREAM, 0)) < 0)
	{
		perror("Error opening socket for store manager ");
		exit(1);
	}

	setsockopt(s, SOL_SOCKET, SO_REUSEADDR, NULL, sizeof(int));
	if(bind(s, (struct sockaddr*) &sin, sizeof(sin)) < 0)
	{
		perror("Error binding socket for store manager");
		exit(1);
	}

	printf("About to listen in store manager on port %i\n", PROXY_PORT);

	listen(s,5);

	len = sizeof(sin);

while(1)
    {
	if(( fd = accept(s, (struct sockaddr *) &sin, &len)) < 0)
	{
		perror("error accepting connection in Server");
		exit(1);
	}

	printf("** Accepted socket in store manager\n");
	printf("** Spawning thread ... (%i) \n", connection_counter); 
	connection_counter++;
	if(pthread_create(&service_tid, NULL,  & (service_proxy_thread), (void*) &fd) == -1)
	    {
		perror("storemanager failed to create service thread for proxy");
	    }
	printf("** Spawn thread ... \n"); 
    }

    close(s);
    printf("Thread listening for proxy connections is shutting down, accepted %i connections\n", connection_counter);
    
	
}


int main(int argc, char** argv)
{
  pthread_t proxy_tid;
  pthread_t alpha_tid;
  char** buffer_arg;


  printf("Store manager started\n");
    /*Initialize lock service */


    if(initialized_lock_service == 0)
      {
    printf("main intializing ALPHA and ETA\n");
      ALPHA_initialize(  );
      ETA_initialize();
      initialized_lock_service = 1;
    printf("main intialized ALPHA and ETA\n");
      }


  //Start thread to listen for proxies connecting to us

  if(pthread_create(&proxy_tid, NULL, & (listen_for_proxy_thread), buffer_arg) == -1)
    {
      perror("storemanager create_thread for proxy");
    }

  pthread_join(proxy_tid, NULL);
  printf("Store manager ended\n");
  
}

#endif









