/*
 * @doc MODULE
 * @module uid.h |
 *
 * Declarations for the Uid string table.
 *
 */


#ifndef __UID_H__
#define __UID_H__
/*
 * @doc TYPE
 * @type Uid | A Uid is really just a char* that is guaranteed to be a unique
 *             identifier for a string.
 *
 */

typedef char* Uid;

extern Uid UID_GetUid(char *string);

/* Never use uidcmp for ordering, only for equality - it only returns 0 or 1 */
#ifdef UID_DEBUG
extern int UID_UidCmp(Uid uid1, Uid uid2);
#define uidcmp(uid1, uid2)  UID_UidCmp(uid1, uid2)
#else
#define uidcmp(uid1, uid2)  (!((uid1) == (uid2)))
#endif /*UID_DEBUG*/

#endif /* __UID_H__ */

