/***************************************************************************
                          uninstalldialog.cpp  -  description
                             -------------------
    begin                : Wed Nov 22 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlistbox.h>
#include <qprogressbar.h>

#include <kmessagebox.h>

#include "uninstalldialog.h"

UninstallDialog::UninstallDialog(GroupTree * gt) : UninstallBase(0,0,true){
	_groupTree = gt;
	grouplist = new QList<FileGroupExt>;
	for (unsigned int i = 0; i < groupTree() -> groupCount(); i++)
		if (groupTree() -> group(i) -> isMarked())
			ListBox1 -> insertItem(groupTree() -> group(i) -> name(),-1);
}

UninstallDialog::~UninstallDialog(){
}

void UninstallDialog::accept(){
	counter = 0;
	batch = new Batch();
	batchProgress = new ButtonLabelWidget2(0,0,true);
	unsigned int steps = 0;
	for (unsigned int i = 0; i < groupTree() -> groupCount(); i++){
		if (groupTree() -> group(i) -> isMarked()){
			batch -> append(groupTree() -> group(i) -> unInstall());
			grouplist -> append((FileGroupExt*)groupTree() -> group(i));
			steps++;
		}
	}
	batchProgress -> ProgressBar1 -> setTotalSteps(steps);
	connect(batch, SIGNAL(processExited()), SLOT(slotProcessExited()));
	connect(batch, SIGNAL(exit()), SLOT(slotBatchExited()));
	batch -> start(true, true);
	setResult(0);
}

void UninstallDialog::reject(){
	setResult(-1);
	hide();
}

void UninstallDialog::slotProcessExited(){
	counter++;
	batchProgress -> ProgressBar1 -> setProgress(counter);
}

void UninstallDialog::slotBatchExited(){
	delete batchProgress;
/*
	QString s1;
	unsigned int cntr = 0;
	s1 += i18n("The next packages were succesful removed:\n");

*/
	for (unsigned int i = 0; i < batch -> count(); i++){
		if (!batch -> process(i) -> error()){
			groupTree() -> removeGroup(grouplist -> at(i));
		}
	}
/*
	if (cntr == 0){
		s1 += i18n("none");
		s1 += "\n";
	}
	s1 += "\n";
	cntr = 0;
	QString s2;
	s2 += i18n("The following problems were encountered:\n");
	for (unsigned int i = 0; i < batch -> count(); i++){
		if (!batch -> process(i) -> error().isEmpty()){
			s2 += i18n("Process: ");
			s2 += batch -> group(i) -> name();
	    s2 += "\n";
			s2 += i18n("Error: ");
			s2 += batch -> process(i) -> error();
			cntr++;
		}
	}
	if (cntr > 0)
  	s1 += s2;
	KMessageBox::information(0,s1);
*/
	hide();
}

