/***************************************************************************
                           krootcontainer.h - 
                         ---------------------------
    begin                : Wed Feb 14 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KROOTCONTAINER_H
#define KROOTCONTAINER_H

#include "kcontainer.h"
#include "knotifychange.h"

class KRootContainerImpl;

/** 
 * @short Bridge class for KRootContainerImpl class. 
 * 
 * @author Sergio Moretti
 * 
 * @version $Id: krootcontainer.h,v 1.2 2001/03/23 17:14:59 sergio Exp $
 */

class KRootContainer : public KContainer 
{
   friend class KObject;
   
public:
   KRootContainer() {}
   static KRootContainer null() { return KRootContainer(); }

   KObject findDefault(int type) const;
   QString fileName() const;
   bool save(const QString &filename = QString::null) const;

   int itemCountGlobal() const;
   int itemActiveCountGlobal() const;

   bool isModified() const;
   void setModified() const;
   void resetModified() const;
   
   void setCallback(KNotifyChange *cb) const;

protected:
   KRootContainer(KRootContainerImpl * impl);
   KRootContainerImpl * impl() const;
   // masked methods
   KObject::toTransfer;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
