/***************************************************************************
                          chatwindow.cpp  -  description
                             -------------------
    begin                : Wed Jul 4 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// my own
#include "chatwindow.h"
#include "chatviewimpl.h"
#include "kmsnapp.h"
#include "chatmember.h"
#include "imservice.h"

// kde
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kstddirs.h>
#include <kglobal.h>
#include <kdebug.h>
#include <kfontdialog.h>
#include <ktextbrowser.h>
#include <khtml_part.h>
#include <khtmlview.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klineeditdlg.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>

// qt
#include <qlist.h>
#include <qprinter.h>
#include <qfile.h>
#include <qpopupmenu.h>
#include <qtextstream.h>
#include <qmultilineedit.h>
#include <qtooltip.h>
#include <qstringlist.h>
#include <qpushbutton.h>
#include <qlabel.h>

// other
#include <time.h>

#define ID_STATUS_MSG 0

#define NUMSMILIES_TOOLBAR	71


ChatWindow::ChatWindow(QWidget *parent, const char *name ) : KMainWindow(parent,name)
{
	chatMemberList.setAutoDelete(true);
	view = new ChatViewImpl(this);
	setCentralWidget(view);	
	// create the actions
	initActions();
	statusBar()->show();
	statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
	createGUI("kmerlinui.rc");
	//create the chat view
	view->viewSmileys = true;
	setCaption("ChatWindow");
	readOptions();
	statusMsg = i18n("Ready.");
	timer_id = startTimer(5000);
	switchBoardIsActive = false; // libkmsn sends a signal if we are connceted with the server
	chatWith = ""; // nobody in chat
	slotStatusMsg(i18n("Ready."));
	connect(view,SIGNAL(sendMsg(QString)),this,SLOT(slotSendButtonClicked(QString)));
	connect(view,SIGNAL(writeMessage()),this,SLOT(slotWriteMessage()));
	
	KStandardDirs dir;
	strPixUser = dir.findResource("data","kmerlin/pics/user.png");
}
ChatWindow::~ChatWindow(){
	saveOptions();        // save the win pos ...
	killTimer(timer_id);
}
/** No descriptions */
void ChatWindow::initActions(){
	KStandardDirs dir;
	fileInvite	= new KToolBarPopupAction(i18n("&Invite"),"filetypes",0, this, SLOT(slotInviteContact()), actionCollection(),"fileInvite");
	fileSave	= KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
	filePrint	= KStdAction::print(this, SLOT(slotFilePrint()), actionCollection());
	fileQuit	= KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection(),"quit");
	fileContact	= new KSelectAction(i18n("&Add Contact"),"find",0, this, SLOT(slotAddContact()), actionCollection(),"fileContactMenu");
	fileInviteMenu	= new KSelectAction(i18n("&Invite"),"find",0, this, SLOT(slotInviteContact()), actionCollection(),"fileInviteMenu");
	editCut 	= KStdAction::cut(this, SLOT(slotEditCut()), actionCollection());
	editCopy	= KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection());
	editPaste 	= KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection());
	editFont	= new KAction(i18n("&Set Font"),"charset",	0, this, SLOT(slotSetFont()), actionCollection(),"font");
	viewToolBar 	= KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
	viewStatusBar 	= KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());
	viewSmileys	= new KToggleAction(i18n("&View Smileys"),"find",0, this, SLOT(slotViewSmileys()), actionCollection(),"viewSmileys");

	toolBarSmiley   = new KToolBarPopupAction(i18n("Smiley"),"amor", 0, actionCollection(),"smiley");
	for (int i = 0; i < 41; i++)
	{
		toolBarSmiley->popupMenu()->insertItem(QPixmap(view->smilies[i]->filename),i);
	}

	connect(toolBarSmiley->popupMenu(),SIGNAL(activated(int)),this,SLOT(slotSmiley(int)));
	// connection for the invite button in toolbar
	connect(fileInvite->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(slotUpdateInviteButton()));
	connect(fileInvite->popupMenu(),SIGNAL(activated(int)),this,SLOT(slotInviteContact(int)));
	// connections in menu
	connect(fileContact->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(slotUpdateContact()));
	connect(fileContact->popupMenu(),SIGNAL(activated(int)),this,SLOT(slotAddContact(int)));
	connect(fileInviteMenu->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(slotUpdateInviteMenu()));
	connect(fileInviteMenu->popupMenu(),SIGNAL(activated(int)),this,SLOT(slotInviteContactMenu(int)));

	fileSave->setStatusText(i18n("Saves the actual document"));
	fileQuit->setStatusText(i18n("Closes the actual document"));
	filePrint ->setStatusText(i18n("Prints out the actual document"));
	fileQuit->setStatusText(i18n("Quits the Chat"));
	editCut->setStatusText(i18n("Cuts the selected section and puts it to the clipboard"));
	editCopy->setStatusText(i18n("Copies the selected section to the clipboard"));
	editPaste->setStatusText(i18n("Pastes the clipboard contents to actual position"));
	viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
	viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));
	viewSmileys->setStatusText(i18n("Enables/disables the smileys"));

}
/** No descriptions */
void ChatWindow::readOptions()
{
	KConfig *config = KGlobal::config();
	config->setGroup("Chat Options");
	KToolBar *aToolBar = toolBar();
	aToolBar->applySettings( config, "ChatWindowToolbar" );
	bool toolbarHidden = config->readBoolEntry( "Hidden" );
	viewToolBar->setChecked( !toolbarHidden );

	// bar status settings
	bool bViewToolbar = config->readBoolEntry("Show Toolbar1", true);
	viewToolBar->setChecked(bViewToolbar);
	bViewToolbar = config->readBoolEntry("Show Smileys", true);
	viewSmileys->setChecked(bViewToolbar);
	view->viewSmileys = bViewToolbar;
	slotViewToolBar();
	bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
	viewStatusBar->setChecked(bViewStatusbar);
	slotViewStatusBar();
	// bar position settings
	KToolBar::BarPosition toolBarPos;
	toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos1", KToolBar::Top);
	toolBar("ChatWindowToolbar")->setBarPos(toolBarPos);

	QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty())
	{
		resize(size);
	}
	QPoint pos=config->readPointEntry("Position");
	if(!pos.isNull())
	{
		move(pos);
	}
	view->fontName = config->readEntry("Font Name","");
//	view->fontSize = config->readEntry("Font Size","");
	myFont = config->readFontEntry("font");
//	view->TextBrowser->setCurrentFont(myFont);
//	view->TextBrowser->setPointSize(myFont.pointSize());
//	view-> strSend->setCurrentFont(myFont);
//	view->strSend->setPointSize(myFont.pointSize());
	view->TextBrowser->setFont(myFont);
	view->strSend->setFont(myFont);
	if(!view->fontName.isEmpty())
	{
		myFont = view->TextBrowser->font();
		view->fontName = myFont.family();
//		view->fontSize = QString::number(myFont.pointSize());
		view->strSend->setFont(myFont);
		view->TextBrowser->setFont(myFont);
	}
}
/** No descriptions */
void ChatWindow::saveOptions()
{
	KConfig *config = KGlobal::config();
	config->setGroup("Chat Options");
	config->writeEntry("Geometry", size());
	config->writeEntry("Position", pos());
	config->writeEntry("Show Toolbar1", viewToolBar->isChecked());
	config->writeEntry("Show Smileys", viewSmileys->isChecked());
	config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
	config->writeEntry("ToolBarPos1", (int) toolBar("ChatWindowToolbar")->barPos());
	config->writeEntry("Font Name",view->fontName);
	config->writeEntry("Font Size",view->fontSize);
	config->writeEntry("font",myFont);
	KToolBar *aToolBar = toolBar();
	aToolBar->saveSettings( config, "ChatWindowToolbar" );
	config->sync();
}
/** No descriptions */
void ChatWindow::slotViewToolBar()
{
	slotStatusMsg(i18n("Toggling toolbar..."));
	///////////////////////////////////////////////////////////////////
	// turn Toolbar on or off
	if(!viewToolBar->isChecked())
	{
		toolBar("mainToolBar")->hide();
	}
	else
	{
		toolBar("mainToolBar")->show();
	}
	slotStatusMsg(statusMsg);
}
/** No descriptions */
void ChatWindow::slotViewStatusBar()
{
	slotStatusMsg(i18n("Toggle the statusbar..."));
	///////////////////////////////////////////////////////////////////
	//turn Statusbar on or off
	if(!viewStatusBar->isChecked())
	{
		statusBar()->hide();
	}
	else
	{
		statusBar()->show();
	}
	slotStatusMsg(statusMsg);
}

void ChatWindow::slotStatusMsg(const QString &text)
{
	///////////////////////////////////////////////////////////////////
	// change status message permanently
	statusBar()->clear();
	statusBar()->changeItem(text,ID_STATUS_MSG);
}

/** No descriptions */
void ChatWindow::slotSetFont()
{
	int result = KFontDialog::getFont( myFont );
	if ( result == KFontDialog::Accepted )
	{
		view->TextBrowser->setFont(myFont);
//		view->TextBrowser->setCurrentFont(myFont);
//		view->TextBrowser->setPointSize(myFont.pointSize());
		view->fontName = myFont.family();
		view->fontSize = QString::number(myFont.pointSize());
		//update the window, hopefully  the font type and size correctly
		//view->TextBrowser->setText(view->TextBrowser->text()+"<fontface=\"\"></font>");
		view->TextBrowser->setText(view->TextBrowser->text()+"");
		view->TextBrowser->scrollBy(0,view->TextBrowser->contentsHeight());
		view->TextBrowser->repaintContents(0,0,view->TextBrowser->contentsWidth(),view->TextBrowser->contentsHeight(),true);
//		view->strSend->setCurrentFont(myFont);
//		view->strSend->setPointSize(myFont.pointSize());
		view->strSend->setFont(myFont);
	}
}

/** No descriptions */
void ChatWindow::slotViewSmileys()
{
	slotStatusMsg(i18n("Turn smileys on off..."));
	///////////////////////////////////////////////////////////////////
	//turn Smileys on or off
	if(!viewSmileys->isChecked())
	{
		view->viewSmileys = false;
	}
	else
	{
		view->viewSmileys = true;
	}
	slotStatusMsg(statusMsg);
}

/** No descriptions */
void ChatWindow::slotFileQuit()
{
	emit closeSession();
	theApp->widgetList.remove(this);
	delete this;
}

/** No descriptions */
void ChatWindow::slotFilePrint()
{
	KHTMLPart *w = new KHTMLPart();
	w->show();
	w->begin();
	w->write(view->TextBrowser->text());
	w->end();
	w->view()->print();
}

/** No descriptions */
void ChatWindow::slotEditCut()
{
	if(view->strSend->hasFocus())
	{
		view->strSend->cut();
	}
}

/** No descriptions */
void ChatWindow::slotEditPaste()
{
	if(view->strSend->hasFocus())
	{
		view->strSend->paste();
	}
}

/** No descriptions */
void ChatWindow::slotEditCopy()
{
	if(view->TextBrowser->hasFocus())
	{
		if(view->TextBrowser->hasSelectedText())
		{
			view->TextBrowser->copy();
		}
	}
	if(view->strSend->hasFocus())
	{
		view->strSend->copy();
	}
}

void ChatWindow::slotFileSave()
{
	QString saveFileName = KFileDialog::getSaveFileName( QString::null , //No start directory
					"*.txt" , //No filter
					this ,   //Where the dialog should be centered on
					i18n( "Save conversation" ) ); //Title
	if ( saveFileName == QString::null )
		return;
	QFile f( saveFileName );
	if (f.open( IO_WriteOnly ) )
	{
		QTextStream t( &f );
		view->TextBrowser->selectAll();
		t << view->TextBrowser->selectedText();
		f.close();
	}
	else
		KMessageBox::error( 0 , //No parent
			i18n("Save failed") , //Short!
			i18n("Error while saving") ); //Caption
}

/**********************   Invite Contact ********************************************************/

/** No descriptions */
void ChatWindow::slotInviteContact()
{
// empty slot	
}

/** Invite a user to the chat  called from Toolbar*/
void ChatWindow::slotInviteContact(int i){
	// switchboard is active- invite
	QString str = fileInvite->popupMenu()->text(i);
	if(str == i18n("Other...") )
	{
		KLineEditDlg dlg("<img src=\"" + strPixUser + "\" valign=\"middle\">" + i18n("Please enter the E-Mail "),"",0);
		dlg.setCaption(i18n("Invite Contact"));
		if(dlg.exec())
		{
			str = dlg.text();
		}
		else
		{
			return;
		}
	}
	if(switchBoardIsActive)
	{
		emit inviteContact(str);
	}
	else
	{			// no switchboard
		slotStatusMsg(i18n("Please wait...."));
		// mmhhhh disable send button?   clicking the send button at this time, it will be create a
		// second session. For test i will disable it here and enable it in slotSwitchBoardIsActive(bool)
		view->SendButton->setEnabled(false);
		chatWith = str;
		emit createSession(str);
	}
}
/** Update the invite button in toolbar */
void ChatWindow::slotUpdateInviteButton()
{
	ChatMember *member;
	bool found = false;
	QString str;
	fileInvite->popupMenu()->clear();
	QStringList list = theApp->imService->getAvailableContacts();
	
	for(QStringList::Iterator it = list.begin(); it != list.end(); ++it)
	{
		str = (*it).latin1();
		found = false;
		for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
		{
			if(member->handle == str)
			{
				found = true;
			}
		}
		if(!found)
		{
			fileInvite->popupMenu()->insertItem(str);
			found = false;
		}
	}
	fileInvite->popupMenu()->insertItem(i18n("Other..."));	
}

/** update the invite menu */
void ChatWindow::slotUpdateInviteMenu()
{
	ChatMember *member;
	bool found = false;
	QString str;
	fileInviteMenu->popupMenu()->clear();
	QStringList list = theApp->imService->getAvailableContacts();
	for(QStringList::Iterator it = list.begin(); it != list.end(); ++it)
	{
		str = (*it).latin1();
		found = false;
		for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
		{
			if(member->handle == str)
			{
				found = true;
			}
		}
		if(!found)
		{
			fileInviteMenu->popupMenu()->insertItem(str);
			found = false;
		}
	}
	fileInviteMenu->popupMenu()->insertItem(i18n("Other..."));		
}

/** No descriptions */
void ChatWindow::slotInviteContactMenu(int i)
{
	// switchboard is active- invite
	QString str;
	str = fileInviteMenu->popupMenu()->text(i);
	if(str == i18n("Other...") )
	{
		KLineEditDlg dlg("<img src=\"" + strPixUser + "\" valign=\"middle\">" + i18n("Please enter the E-Mail "),"",0);
		dlg.setCaption(i18n("Invite Contact"));
		if(dlg.exec() )
		{
			str = dlg.text();
		}
		else
		{
			return;
		}
	}
	if(switchBoardIsActive)
	{
		emit inviteContact(str);
	}
	else
	{
		// no switchboard
		slotStatusMsg(i18n("Please wait...."));
		// mmhhhh disable send button?   clicking the send button at this time, it will be create a
		// second session. For test i will disable it here and enable it in slotSwitchBoardIsActive(bool)
		view->SendButton->setEnabled(false);
		chatWith = str;
		emit createSession(str);
	}
}

/**************************** Add Contact *****************************************/
/** This update the add contact menu */
void ChatWindow::slotUpdateContact()
{
	ChatMember *member;
	fileContact->popupMenu()->clear();
	for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
	{
		if(member->inContactList)
		{
			fileContact->popupMenu()->insertItem(member->handle);
		}
	}
	fileContact->popupMenu()->insertItem(i18n("Other..."));
}

void ChatWindow::slotAddContact()
{
}
/** this add the selected contact
to the contact list */
void ChatWindow::slotAddContact(int i)
{
	if(fileContact->popupMenu()->text(i) == i18n("Other...") )
	{
		theApp->slotContactAdd();
	}
	else
	{
//		theApp->imService->  ( fileContact->popupMenu()->text(i), fileContact->popupMenu()->text(i));
	}
}

/******************************** Events **********************************************/
/** No descriptions */
void ChatWindow::closeEvent(QCloseEvent*){
	slotFileQuit();
}

/** No descriptions */
void ChatWindow::timerEvent(QTimerEvent* ev)
{
	if(ev->timerId() == timer_id)
	{
		if(view->textChanged)
		{
			emit typingMsg();
			view->textChanged = false;
		}
		else
		{
			updateStatusText();
		}
	}
}

/****************************************** Helper *********************************************/
/** Change the text in infoText */
void ChatWindow::updateInfoText(QString text)
{
	view->infoText->setText(text);
}

/** No descriptions */
void ChatWindow::slotChatWith(QString handle,bool av){
	chatWith = handle;
	available = av;
	setCaption(i18n("Short Message -")+ " " +theApp->imService->getPublicName(chatWith));
	if(!waitingMessage.isEmpty()){
		if(av){
			// send waiting message
			sendMsg(waitingMessage);
			waitingMessage = "";
		}
	}
}

void ChatWindow::updateStatusText()
{
	ChatMember *member;
	QString publicName1;
	time_t TR_ID =  time((time_t *)NULL);
	QString statusText;
	for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
	{
		if( (TR_ID - member->timeStamp) <= 6)
		{
			publicName1 = member->publicName;
			publicName1 = publicName1.replace(QRegExp("<"),"&lt;");
			publicName1 = publicName1.replace(QRegExp(">"),"&gt;");
			statusText += publicName1 + ",  ";
		}
	}
	if( !statusText.isEmpty() )
	{
		slotStatusMsg(statusText + i18n("writes a message") );
	}
	else
	{
		// nothing todo - display default msg
		slotStatusMsg(statusMsg);
	}
}

/********************************** SLOTS *******************************************/
/** No descriptions */
void ChatWindow::slotSwitchBoardIsActive(bool active)
{
	switchBoardIsActive = active;
	if(!view->strSend->text().isEmpty() && view->strSend->text() != "\n")   // disabled in slotInviteUser()
	{
		if(!view->SendButton->isEnabled())
		{
			view->SendButton->setEnabled(true);
		}
	}
}

/** No descriptions */
void ChatWindow::slotSendButtonClicked(QString msg)
{
	if(switchBoardIsActive)
	{
		if(available)
		{
			// ok send the message
			emit sendMsg(msg);
			waitingMessage = "";
		}
		if(!available)
		{
			// not in chat- invite
			emit inviteContact(chatWith);
			waitingMessage  = msg; // send it later
			slotStatusMsg(i18n("Please wait...."));
		}
	}
	if(!switchBoardIsActive)
	{
		// chat session is closed, reconnect
		emit createSession(chatWith);
		waitingMessage = msg;
		slotStatusMsg(i18n("Please wait...."));
	}
}

void ChatWindow::slotContactTyping(QString handle)
{
	ChatMember *member;
	// serch handle in ChatMemberList
	for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
	{
		if(member->handle == handle)
		{
			// this is the correct one
			// set a time stamp
			member->timeStamp = time((time_t *)NULL);
			updateStatusText();
			return;
		}
	}
}

void ChatWindow::slotUpdateChatMemberList(QString handle, QString command,bool last)
{
	ChatMember *member;
	QString dummy,dummy1,dummy2, publicName1;
	QString publicName = theApp->imService->getPublicName(handle);
	bool b = false;
	if(command == "BYE")
	{
		// remove member
		for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
		{
			if( member->handle  == handle)
			{
				if(chatMemberList.count() <= 1)
				{
			 	// create some info in infoText?  nobody in chat
				chatMemberList.remove(member);
				slotChatWith(handle,false);
				}
				else
				{
					chatMemberList.remove(member);
					publicName1 = publicName;
					publicName1 = publicName1.replace(QRegExp("<"),"&lt;");
					publicName1 = publicName1.replace(QRegExp(">"),"&gt;");
					view->systemMessage(publicName1 + i18n(": has left the session"));
				}
			}
		}
	}
	if(command == "IRO")
	{
		// create new
		member = new ChatMember(handle,publicName);
		member->inContactList = theApp->imService->isNewContact(handle);
		chatMemberList.append(member);
		if(chatMemberList.count() > 1 )
		{
			if(last)
			{
				// this is the last in this multi chat session, create a system message
				for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
				{
					publicName1 = member->publicName;
					publicName1 = publicName1.replace(QRegExp("<"),"&lt;");
					publicName1 = publicName1.replace(QRegExp(">"),"&gt;");

					dummy += "<b>" + publicName1 + "</b>"  + "  " + member->handle + "<br>";
				}
				view->systemMessage(i18n("You are talking with:") +"<br>" + dummy);
			}
		}
		else
		{
			slotChatWith(handle,true);
		}
	}
	if(command == "JOI")
	{
		member = new ChatMember(handle,publicName);
		member->inContactList = theApp->imService->isNewContact(handle);
		chatMemberList.append(member);
		 // send Info to chatView
		 if(chatMemberList.count() <= 1)
		 {
		 	slotChatWith(handle,true);
		}
		else
		{
			publicName1 = publicName;
			publicName1 = publicName1.replace(QRegExp("<"),"&lt;");
			publicName1 = publicName1.replace(QRegExp(">"),"&gt;");
			view->systemMessage(publicName1 + i18n(" has joined the session"));
		}
	}
	if( chatMemberList.count() == 0)
	{
		// i'm alone
		updateInfoText(handle + " " + i18n("has closed the chat window,<br>if you send a message they will be invited immediatly!"));
		publicName1 = publicName;
		publicName1 = publicName1.replace(QRegExp("<"),"&lt;");
		publicName1 = publicName1.replace(QRegExp(">"),"&gt;");
		QToolTip::add(view->infoText,i18n("There is nobody in this Chat session!<br>If you send a message,")+"<b>" + publicName1 + "</b> " + i18n("will be invited immediatly")) ;
	}
	else
	{
		dummy = "";
		dummy1 = i18n("This person(s) are in your chat session") +"<br>";
		dummy2 = i18n("This person(s) are not in your Contact List:") +"<br>";
		for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
		{
			publicName1 = member->publicName;
			publicName1 = publicName1.replace(QRegExp("<"),"&lt;");
			publicName1 = publicName1.replace(QRegExp(">"),"&gt;");
			dummy += publicName1 + " <a href=\"mailto: " + member->handle + "\"> " + member->handle + "</a> ";
			dummy1 += "<b>" + publicName1 + "</b><a href=\"mailto: " + member->handle + "\">" + member->handle + "</a><br>";
			if(member->inContactList)
			{
				dummy2 += member->handle + "<br>";
				b = true;
			}
		}
		updateInfoText(dummy);
		if(b)
		{
			dummy2 += i18n("You can add this Contact(s) in the File Menu");
			dummy1 += dummy2;
		}
		QToolTip::add(view->infoText,dummy1);
	}
}

void ChatWindow::slotMsgAcknowledgement(bool f)
{
	QString strTime;
	strTime=KGlobal::locale()->formatDateTime(QDateTime::currentDateTime(),false,true);
	if(f)
	{
		statusMsg = i18n("Your last message was received at : ") +strTime;
	}
	else
	{
		statusMsg = i18n("Your last message was not received : ")+strTime;	
	}
	updateStatusText();
}

void ChatWindow::slotMsgReceived(QString handle, QString publicName, QString msg)
{
	view->insertMessage(publicName,msg);
	ChatMember *member;
	// serch handle in ChatMemberList
	for ( member = chatMemberList.first(); member != 0; member=chatMemberList.next() )
	{
		if(member->handle == handle)
		{
			// this is the correct one
			// set a time stamp
			member->timeStamp = member->timeStamp -6;
			updateStatusText();
		}
	}
}

void ChatWindow::slotWriteMessage()
{
	if(switchBoardIsActive)
	{
		emit typingMsg();
	}
	else
	{
		// do nothing;
	}
}

void ChatWindow::slotSmiley(int index)
{
	view->strSend->insert(view->smilies[index]->display);
}

//Speed up compilation
#include "chatwindow.moc"
