/***************************************************************************
                          kmsnapp.h  -  description
                             -------------------
    begin                : Mon Jul 23 2001
    copyright            : (C) 2001 by olaf lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMSNAPP_H
#define KMSNAPP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <qwidget.h>
#include <kmainwindow.h>
#include <kaction.h>


/**Base class from KMsn
  *@author olaf lueg
  */
// forward declaration
class OnlineView;
class KMsn;
class ChatWindow;
class IdleTimer;
class SettingsDialog;
class SystemNotifier;

class IMService;
class IMChatService;

class KMsnApp : public KMainWindow
{
	Q_OBJECT
public:
	KMsnApp(QWidget *parent=0, const char *name=0);
	~KMsnApp();
	IMService *imService;
	QList<ChatWindow> widgetList;
	SystemNotifier* notifierWidget;
	int notificationTimeout;
	SettingsDialog *settings;
	int mailTimer;
	int con_id,mail_id, state_id;
	uint currentStatus;
	int defaultUser;
	bool autoConnect;
	bool connected,userSettings,enableIdleDetection,counter;
	bool visible;
	int maxIdle;
	/** create the menu and toolbar */
	void initActions();
	/** No descriptions */
	void saveOptions();
	//Load in the window settings, as well as the profiles
	void readOptions();
	/** No descriptions */
	void saveProperties(KConfig* _cfg);
	/** No descriptions */
	void readProperties(KConfig* _cfg);

	// Events
	/** No descriptions */
	void timerEvent(QTimerEvent *ev);
	void closeEvent(QCloseEvent*);
	// widgets
	OnlineView *viewWidget;
	KMsn *systemTrayWidget;
	
	void stopWorkTimer();

	// id's online state
	int id_online,id_busy,id_back,id_away,id_phone,id_lunch,id_invisible;

	// idletimer
	IdleTimer *idleTimer;

	// Actions
	KActionMenu *fileConnector;
	KAction* fileQuit;
	KSelectAction* fileStatus;
	KAction* fileDisconnector;
	KAction* fileHide;

	KAction* contactAdd;
	KActionMenu* contactMove;
	KActionMenu* contactCopy;
	KAction* contactRemove;
	KAction* contactDelete;
	KAction* contactBlock;
	KAction* contactUnBlock;
	KAction* contactChat;
	
	KAction* groupAdd;
	KAction* groupRename;
	KAction* groupDelete;

	KAction* viewSettings;
	KToggleAction* viewToolBar;
	KToggleAction* viewStatusBar;
	KToggleAction* viewEmailCheck;
	KToggleAction *fileAddToPanel;

	KPopupMenu *contextMenu;
	
	bool isConnected(){return connected;}
	QString getHandle(){return handle;}


public slots: // Public slots
	/** toggle the statusbar */
	void slotViewStatusBar();
public slots: // Public slots
	/** No descriptions */
	void slotViewToolBar();
public slots: // Public slots

	void slotFileQuit();
	void slotStatus();

	void slotHide();
	// Connect to MSN service with profile id
	void slotConnector( int id );
	// Cancel or disconnect from MSN service
	void slotDisconnector();
	/** disable auto connect */
	void slotConnectorClicked(int);
	
	void slotStatusMsg(const QString & text);
	
	/** change the status */
	void slotChangeStatus(int i);
	
	//Catch when the settingsdialog is closed, to reload the settings
	void slotSettingsDialogClosed();

	// Display the contectMenu
	void slotShowContextMenu(const QPoint& point);


	void slotOpenChatWindow(IMChatService *board,QString handle);

	void slotHideEmail();
	void slotSettings();
	void slotConnectedToMsn(bool f);
	
	
	void slotIncomingMail(QString addy,uint count);
	void slotToggleIdle(bool f);

	void slotShowNotifierWidget(QString handle,uint status);
	void slotUpdateStatus(uint status);
	
	void slotPublicNameChanged(QString _publicName);

	void slotContactAdd();
	void slotContactCopy();
	void slotContactCopy(int i);
	void slotContactMove(int i);
	void slotContactMove();
	void slotContactRemove();
	void slotContactDelete();
	void slotContactBlock();
	void slotContactAllow();
	void slotContactAllow(QString _handle);
	void slotContactChat();
	void slotGroupAdd();
	void slotGroupRename();
	void slotGroupDelete();
	
	void slotUpdateMenu();
	// test slot
	void slotAutoConnect();
	// Auth
	void slotAuthenticate( QString handle );
	void slotAddContact( QString handle);
	void slotBlockContact( QString handle );
	void slotChangePublicName(QString publicName);
	
	void slotAddToPanel();
signals:
	void connectToService();
protected:
	QStringList profiles;     //List of profiles
	QString handle;           //Username (e-mail)
	QString publicName;       //Nickname
	QString password;         //Password
	unsigned short int curProfile;//An int pointing to the profile in profiles list
	QString curProfileName;   //and the name...
	QList<KAction> actions;   //The actions used by the profiles
	bool _silent;
	int _autoConnectTimer;    // auto connect timer
	int _workTimer;            //
	bool _autoConnect;        // only for internal use
	bool enableAlert;          // enable alert window
};
#endif
