/***************************************************************************
                          emoticon.cpp  -  description
                             -------------------
    begin                : Mon Apr 15 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "emoticon.h"

#include <qdir.h>
#include <qfile.h>
#include <qstring.h>
#include <qstringlist.h>

#include <kconfig.h>
#include <kstandarddirs.h>

Emoticon::Emoticon( QString text, QString file ) : QObject( 0, 0 )
{
  QString        emoticonPath;
  KStandardDirs *dirs   = KGlobal::dirs();

  text_.clear();

  // Set the text and file to those given
  text_.append( text );
  file_ = file + ".png";

  emoticonPath = dirs->findResource( "data", "kmess/emoticons/" + file_ );

  if ( emoticonPath == QString::null )
  {
    valid_ = false;
  }
  else
  {
    valid_ = true;
  }

  // Set the resulting whole path as the new file
  setFile( emoticonPath );
}



Emoticon::~Emoticon()
{
}



// Add another text element into QStringList text_
void Emoticon::addText( QString text )
{
  text_.append( text );
}



// Read property of QString file_.
const QString& Emoticon::getFile() const
{
  return file_;
}



// Get a suitable bit of HTML for the emoticon.
QString Emoticon::getHtml( bool small ) const
{
  QString html, size;

  if ( small )
  {
    size="16";
  }
  else
  {
    size="20";
  }

  html = "<img src=\"" + getFile() + "\" height=" + size + " width=" + size + ">";

  return html;
}



// Get a pattern which will match any of the variants of the emoticon
QString Emoticon::getPattern() const
{
  QString pattern;
  QStringList::const_iterator variant;

  pattern = "(";
  for ( variant = text_.begin(); variant != text_.end() ; variant++ )
  {
    pattern += (*variant) + "|";
  }

  // truncate the last character
  pattern.setLength( pattern.length() - 1 );

  pattern += ")";

  return pattern;
}


// Read property of QString  text_.
QString Emoticon::getText() const
{
  return text_.first();
}



// Is the emoticon valid - ie, can we find an icon for it?
bool Emoticon::isValid() const
{
  return valid_;
}



// Read property of QString  tooltip_.
QString Emoticon::getTooltip() const
{
  return tooltip_;
}

// Does the emoticon have a tooltip?
bool Emoticon::hasTooltip() const
{
  return hasTooltip_;
}



// Write property of QString file_.
void Emoticon::setFile( const QString& _newVal)
{
  file_ = _newVal;
}



// Write property of QString  text_.
void Emoticon::setText( const QString & /*_newVal*/)
{
//  text_ = _newVal;
}



// Write property of QString tooltip_.
void Emoticon::setTooltip( const QString & _newVal)
{
  hasTooltip_ = true;

  tooltip_ = _newVal;
}


#include "emoticon.moc"
