/***************************************************************************
                          idletimer.cpp  -  description
                             -------------------
    begin                : Tue Oct 22 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "idletimer.h"

#include <kdebug.h>

#include "currentaccount.h"
#include "kmessdebug.h"
#include "xautolock.h"

// The constructor
IdleTimer::IdleTimer()
: QObject()
{
  watcher_ = new XAutoLock();
  // Connect the timer to signal when the user is away.
  connect( watcher_, SIGNAL( timeout()       ),
           this,     SLOT  ( slotTimeout()   ) );
  connect( watcher_, SIGNAL( activity()      ),
           this,     SLOT  ( slotActivity()  ) );
  watcher_->stopTimer();
  account_ = CurrentAccount::instance();
  // Make the connections
  connect( account_, SIGNAL( changedTimerSettings() ),
           this,     SLOT  ( updateWatcher()        ) );
}



// The destructor
IdleTimer::~IdleTimer()
{
  delete watcher_;
#ifdef KMESSDEBUG_IDLETIMER
  kdDebug() << "DESTROYED IdleTimer" << endl;
#endif
}



// Echo the watcher's timeout.
void IdleTimer::slotTimeout()
{
  emit timeout();
}



// Echo the watcher's activity .
void IdleTimer::slotActivity()
{
  emit activity();
}



// Reset the watcher based on the account's settings.
void IdleTimer::updateWatcher()
{
#ifdef KMESSDEBUG_IDLETIMER
  kdDebug() << "IdleTimer::updateWatcher()" << endl;
#endif
  watcher_->setTimeOut( account_->getIdleTime() * 60 );
  if ( account_->getUseIdleTimer() )
  {
#ifdef KMESSDEBUG_IDLETIMER
    kdDebug() << "IT:   Start the timer." << endl;
#endif
    watcher_->startTimer();
  }
  else
  {
#ifdef KMESSDEBUG_IDLETIMER
    kdDebug() << "IT:   Stop the timer." << endl;
#endif
    watcher_->stopTimer();
  }
#ifdef KMESSDEBUG_IDLETIMER
  kdDebug() << "IT:   Done updateWatcher()." << endl;
#endif
}

#include "idletimer.moc"
