/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef C_SMS_H
#define C_SMS_H

#include <qobject.h>
#include <qstringlist.h> 
#include <kabc/addressee.h>
#include <qptrlist.h> 
#include <qdatetime.h> 
#include <kdebug.h>


/**
@author Marco Gulino
*/
class c_SMS : public QObject
{
Q_OBJECT
public:
    c_SMS(QObject *parent = 0, const char *name = 0);
    c_SMS(const QString data, const QString memSlot, bool toDecode=false, bool pdu=false,  QObject *parent = 0, const char *name = 0);
    c_SMS(const QStringList numbers, const QStringList text);
    ~c_SMS();
    QStringList Numbers() { return sl_Numbers; }
    QStringList TextList() { return sl_TextList; }
    QString Header() { return s_Header; }
	int Type() { return i_Type; }
	QString id() { return s_ID; }
	QString getDateTime() { return smsDateString; }
	QString memSource() { return memsrc; }
	bool isNotified() { return notified; }
    void initSMS(const QString data, const QString memslot, bool toDecode=false, bool pdu=false);
	bool getInList() { return inList; }
	void setInList( bool inListflag) { inList=inListflag; }
	void setType( int newType ) { i_Type=newType; }
	void setId( const QString newId ) { s_ID=newId; }
	void setMemSRC( const QString newMemSRC) { memsrc=newMemSRC; }
	void setDateTime( const QDateTime dateTime ) { smsDate=dateTime; }
	void notify() { notified=true; }
    const QString getPDUStream();

	static const int REC_UNREAD=0;
	static const int REC_READ  =1;
	static const int STO_UNSENT=2;
	static const int STO_SENT  =3;
	static const int ALL       =4;
	static const int HEADER    =5;
	
	inline bool operator==( /*c_SMS &sms1, */c_SMS &sms2 )
	{
		return (
			( TextList() == sms2.TextList() ) &&
			( Numbers()  == sms2.Numbers() ) );
	}
    static c_SMS* findSMS( QPtrList<c_SMS>* smsList, int id);
    QStringList getParsedNumList();
    QString toString();
    QString toSpeechString();
    static const QString getPDUNum(const QString numString);
    static const QString getPDUDate(const QString strDate);
    static const char* strToBits( const QString strNum );
    static const QChar bitsToChar(const char* bits);
    static const QString getFrom7bits(const QString pduText, unsigned int length=0);
    static const QString getFrom8bits(const QString strText);
    static const QString getFrom16bits(const QString strText);
    static const QString decodePDUText(const QString text,const  QString encoding);
    static const QString fromGSMAlphabet(const QString src);
    static const QString toPDUNum(const QString num);
    static QString textTo7bits(QString text);
	
protected:
    QString s_Header;
    QStringList sl_Numbers;
    QStringList sl_TextList;
	int i_Type;
    int i_Numbers;
    QString s_ID;
    int i_Texts;
	bool inList;
	QString memsrc;
	QDateTime smsDate;
	QString smsDateString;
	bool notified;
};

#endif
