/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kiconloader.h>
#include <kdeversion.h>
#include <kpushbutton.h> 
#include <klistview.h>
#include <klocale.h>
#include <qlabel.h> 
#include <qbuttongroup.h> 
#include <qcheckbox.h> 
#include <kdialogbase.h> 
#include <kmessagebox.h> 
#include <qtimer.h>
#include <qlayout.h>
#include <qstylesheet.h> 
#include <kactivelabel.h>
#include <kfiledialog.h> 
#include <qfile.h>
#include <qtextstream.h> 
#include <qregexp.h> 
#include <dcopclient.h>
extern DCOPClient* dcopclient;

#include "d_smslist.h"
#include "c_sms.h"
#include "kmobiletools.h"
#include "d_newsms.h"

#include "gsm.h"
extern GSM* d_gsm;
#include "threadedgsm.h"
extern threadedGSM gsmThread;

#include <iostream>
using namespace std;

d_SMSList::d_SMSList(QWidget *parent, const char *name)
 : KDialogBase( parent, name, true, i18n("SMS list dialog"), KDialogBase::Close | KDialogBase::User1 | KDialogBase::User2| KDialogBase::User3 )
{
	mainWidget= new ui_SMSList ( this );
	setMainWidget (mainWidget );
	if( QString(name)== "recSMS" )
	{
		mainWidget->checkBox3->setChecked(false);
		mainWidget->checkBox4->setChecked(false);
		mainWidget->checkBox1->setChecked(true);
		mainWidget->checkBox2->setChecked(true);

	}
	if( QString(name)== "outSMS" )
	{
		mainWidget->checkBox3->setChecked(true);
		mainWidget->checkBox4->setChecked(true);
		mainWidget->checkBox1->setChecked(false);
		mainWidget->checkBox2->setChecked(false);
	}
	#if KDE_IS_VERSION(3,3,0)
	setButtonGuiItem( KDialogBase::User1, KGuiItem( i18n("New SMS"), "mail_new") );
	setButtonGuiItem( KDialogBase::User2, KGuiItem( i18n("Save SMS List"), "save_all") );
	setButtonGuiItem( KDialogBase::User3, KGuiItem( i18n("Reload SMS List"), "reload") );
	#else
	setButtonText( KDialogBase::User1, i18n("New SMS") );
	setButtonText( KDialogBase::User2, i18n("Save SMS List") );
	setButtonText( KDialogBase::User3, i18n("Reload SMS List") );
	#endif

	mainWidget->b_send->setIconSet( QIconSet( KGlobal::iconLoader()->loadIcon( "mail_send" , KIcon::FirstGroup, KIcon::SizeSmall ) ));
	mainWidget->b_save->setIconSet( QIconSet( KGlobal::iconLoader()->loadIcon( "filesave" , KIcon::FirstGroup, KIcon::SizeSmall ) ));
	mainWidget->b_delete->setIconSet( QIconSet( KGlobal::iconLoader()->loadIcon( "mail_delete" , KIcon::FirstGroup, KIcon::SizeSmall ) ));
	
	mainWidget->pl1->setPixmap(  KGlobal::iconLoader()->loadIcon( "bookmark" , KIcon::FirstGroup, KIcon::SizeSmall ) );
	mainWidget->pl2->setPixmap(  KGlobal::iconLoader()->loadIcon( "mail_get" , KIcon::FirstGroup, KIcon::SizeSmall ) );
	mainWidget->pl3->setPixmap(  KGlobal::iconLoader()->loadIcon( "queue" , KIcon::FirstGroup, KIcon::SizeSmall ) );
	mainWidget->pl4->setPixmap(  KGlobal::iconLoader()->loadIcon( "mail_send" , KIcon::FirstGroup, KIcon::SizeSmall ) );
	
	connect( mainWidget->l_sms, SIGNAL( selectionChanged( QListViewItem* ) ), this, SLOT(selectionChanged(QListViewItem* ) ) );
	connect( mainWidget->bg_listopts, SIGNAL( clicked(int) ), this, SLOT(changedFilter(int ) ) );
	connect( mainWidget->b_delete, SIGNAL( clicked() ), this, SLOT(deleteSMS() ) );
	connect( mainWidget->b_send, SIGNAL( clicked() ), this, SLOT(sendSMS() ) );
	connect( mainWidget->b_save, SIGNAL( clicked() ), this, SLOT(saveSMS() ) );
	
	mainWidget->l_sms->setColumnWidthMode(0, QListView::Manual);	
	mainWidget->l_sms->setColumnWidthMode(1, QListView::Manual);	
	mainWidget->l_sms->setColumnWidthMode(2, QListView::Manual);
	initList();
	resize(530,450);
	QTimer *refresh=new QTimer(this);
	connect(refresh,SIGNAL(timeout()),this, SLOT(refreshSMSList() ) );
	refresh->start(250, false);
}


d_SMSList::~d_SMSList()
{
}


#include "d_smslist.moc"

void d_SMSList::initList()
{
	mainWidget->l_sms->clear();
	mainWidget->txt_smsText->setText( i18n("SMS info") );
	mainWidget->b_send->setEnabled(false);
	mainWidget->b_delete->setEnabled(false);
	mainWidget->b_save->setEnabled(false);
// 	smsList=*(d_gsm->getSMSList() );
	QPtrListIterator<c_SMS> it( *(d_gsm->getSMSList() ) );
	c_SMS* sms;
	int i=0;
	while ( (sms=it.current() ) !=0 )
	{
		KListViewItem* item=new KListViewItem( 
			mainWidget->l_sms,  sms->id(),  /*QString::number( sms->Type() )*/ "", 
			sms->getParsedNumList().join( ", " ), sms->TextList().join ( " " ),
			QString::number(i),
			QString::number( sms->Type() )
			);
		switch( sms->Type() ){
			case c_SMS::REC_UNREAD:
				item->setPixmap ( 1, * ( mainWidget->pl1->pixmap() ) );
				break;
			case c_SMS::REC_READ:
				item->setPixmap ( 1, * ( mainWidget->pl2->pixmap() ) );
				break;
			case c_SMS::STO_SENT:
				item->setPixmap ( 1, * ( mainWidget->pl4->pixmap() ) );
				break;
			case c_SMS::STO_UNSENT:
				item->setPixmap ( 1, * ( mainWidget->pl3->pixmap() ) );
				break;
		}
		++it; i++;
	}
	changedFilter(0);
}

void d_SMSList::selectionChanged( QListViewItem* item)
{
	if(item==0) 
	{
		mainWidget->txt_smsText->setText( i18n("SMS info") );
		mainWidget->b_send->setEnabled(false);
		mainWidget->b_delete->setEnabled(false);
		return;
	}
	mainWidget->b_send->setEnabled(true);
	mainWidget->b_delete->setEnabled(true);
	mainWidget->b_save->setEnabled(true);
	d_gsm->getSMSList()->first();
	c_SMS* sms=d_gsm->getSMSList()->at( item->text(4).toInt() );
	
		QString numList;
		QStringList nList(sms->Numbers() );
		for( QStringList::Iterator lit=nList.begin(); lit!=nList.end() ; ++lit )
		{
			if ( lit!=nList.begin() ) numList+=", ";
			QString curNum=*lit;
			numList+= QString( "<a href='whatsthis:" ) ;
			numList+= curNum;
			numList+= "'>";
			numList+=  QStyleSheet::escape(d_gsm->getNameFromNumber( curNum ) ) + "</a>";
		}

		QString smsText=i18n( "Message %2 %1." ).arg( numList ) + "<br>\n";
	
	if( sms->Type() == c_SMS::REC_READ || sms->Type() == c_SMS::REC_UNREAD ) smsText=smsText.arg( i18n("from") );
	if( sms->Type() == c_SMS::STO_UNSENT || sms->Type() == c_SMS::STO_SENT ) smsText=smsText.arg( i18n("to") );
	I18N_NOOP( "_n: Date: %1, %n character long.\nDate: %1, %n characters long.");
	smsText+= i18n( "Date: %1, %n character long.", "Date: %1, %n characters long.", ( sms->TextList().join(" ").length() ) )
			.arg( QStyleSheet::escape( sms->getDateTime() ) );
	smsText.append("<hr>").append( QStyleSheet::escape( sms->TextList().join("\n") )
	);
	QRegExp repl_link;
	repl_link.setCaseSensitive(false);
	repl_link.setPattern("\\b(http://\\S+)\\b");
	smsText=smsText.replace( repl_link, "<a href=\"\\1\">\\1</a>");
	repl_link.setPattern("(\\s)(www\\.\\S+)\\b");
	smsText=smsText.replace( repl_link, "\\1<a href=\"http://\\2\">\\2</a>");
	repl_link.setPattern("\\b(\\w+\\@\\w+\\.\\w+\\.?\\w*)\\b");
	smsText=smsText.replace( repl_link, "<a href=\"mailto:\\1\">\\1</a>");
	mainWidget->txt_smsText->setText( smsText );
/*QByteArray data, recvd, data2;
QCString rettype;/*
kdDebug() << "Sending notice to kttsd" << endl;
   QDataStream arg(data, IO_WriteOnly);
    arg << sms->toString();
	arg << QString("");
kdDebug() << "kmobiletools-kttsd-sending-dcop message " << 
/*	dcopclient->send( "kttsd", "KSpeech", "sayMessage(QString, QString)", data )  
	dcopclient->send( "kttsd", "KSpeech", "sayMessage(QString, QString)", data )
<< endl;
*/
QString text=sms->toSpeechString();
    QByteArray  data;
    QByteArray  data2;
    QCString    replyType;
    QByteArray  replyData;
    QDataStream arg(data, IO_ReadWrite);
    arg << text << "";
kdDebug() << "sending to kttsd\n" << text << endl;
    if ( !dcopclient->call("kttsd", "KSpeech", "setText(QString,QString)",
                       data, replyType, replyData, true) )
       kdDebug() << i18n( "The DCOP call setText failed." ) << endl;

    QDataStream arg2(data2, IO_WriteOnly);

    arg2 << 0;
    if ( !dcopclient->call("kttsd", "KSpeech", "startText(uint)",
                       data2, replyType, replyData, true) )
                                kdDebug() << i18n( "The DCOP call startText failed." ) << endl;

}


/*!
    \fn d_SMSList::changedFilter(int)
 */
void d_SMSList::changedFilter(int i)
{
	i++; // we really DON'T need this.. but otherwise it'll generate a warning.. so that's ok :)
	QListViewItemIterator it( mainWidget->l_sms );
	while ( it.current() ) {
		QListViewItem *item = it.current();
		if( item->text(5).toInt() == c_SMS::REC_READ) item->setVisible( mainWidget->checkBox2->isChecked() );
		if( item->text(5).toInt() == c_SMS::REC_UNREAD ) item->setVisible( mainWidget->checkBox1->isChecked() );
		if( item->text(5).toInt() == c_SMS::STO_SENT ) item->setVisible( mainWidget->checkBox4->isChecked() );
		if( item->text(5).toInt() == c_SMS::STO_UNSENT ) item->setVisible( mainWidget->checkBox3->isChecked() );
		if( !item->isVisible() && mainWidget->l_sms->isSelected(item) ) selectionChanged(0);
		if( item->isVisible() && mainWidget->l_sms->isSelected(item) ) selectionChanged(item);
		++it;
    }
}

void d_SMSList::deleteSMS()
{
	if( mainWidget->l_sms->selectedItem() == 0 ) return;
	if (KMessageBox::warningYesNo( this, i18n("Do you really want to delete this message?"), i18n("Confirmation"))
		== KMessageBox::Yes ) gsmThread.delSMS( mainWidget->l_sms->selectedItem()->text(0) );
}

void d_SMSList::slotUser1() // new SMS
{
	d_NewSMS* newSMS=new d_NewSMS(this, "L-newSMSWin") ;
	newSMS->show();
}

void d_SMSList::slotUser2() // Save SMS List
{
	QString filename=KFileDialog::getSaveFileName();
	if( filename.length() <=0 ) return;
	QFile filesave(filename);
	filesave.open(IO_WriteOnly);
    QTextStream stream( &filesave );
	stream << d_gsm->getSMSList()->toString("\n\n------------------------------\n\n");
	filesave.close();
}

void d_SMSList::slotUser3() // Reload SMS List
{
	d_gsm->clearSMSList();
}
/*!
    \fn d_SMSList::sendSMS()
 */
void d_SMSList::sendSMS()
{
	if( mainWidget->l_sms->selectedItem() == 0 ) return;
	if ( d_gsm->sendSMS( mainWidget->l_sms->selectedItem()->text(0) ) )
		KMessageBox::information ( this, i18n("Message sent correctly."), i18n("Message sent") );
	else
		KMessageBox::error( this, i18n("An error occurred while sending this SMS."), i18n("Error") );
}

void d_SMSList::saveSMS()
{
	QString filename=KFileDialog::getSaveFileName();
	if( filename.length() <=0 || mainWidget->l_sms->currentItem() ==0 ) return;
	c_SMS* sms=d_gsm->getSMSList()->at( mainWidget->l_sms->currentItem()->text(4).toInt() );
	QFile filesave(filename);
	filesave.open(IO_WriteOnly);
    QTextStream stream( &filesave );
	stream << sms->toString();
	filesave.close();
}

/*!
    \fn d_SMSList::refreshSMSList()
 */
void d_SMSList::refreshSMSList()
{
	QListViewItemIterator l_it( mainWidget->l_sms );
	while ( l_it.current() ) 
	{
		QListViewItem *item = l_it.current();
		bool found=false;
		
		QPtrListIterator<c_SMS> it( *(d_gsm->getSMSList() ) );
		c_SMS* sms;
		while ( (sms=it.current() ) !=0 )
		{
			if (sms->id() == item->text(0) )
				{
					found=true; 
					sms->setInList(true);
					break;
				}
			++it;
		}
		if (!found) mainWidget->l_sms->takeItem(item);
		++l_it;
    }
	QPtrListIterator<c_SMS> it( *(d_gsm->getSMSList() ) );
	c_SMS* sms;
	int i=0;
	it.toFirst();
	while ( (sms=it.current() ) !=0 )
	{
		if(!sms->getInList())
		{
			KListViewItem* item=new KListViewItem( 
			mainWidget->l_sms, sms->id(),  /*QString::number( sms->Type() )*/ "", 
			sms->getParsedNumList().join(", "), sms->TextList().join ( " " ),
			QString::number(i),
			QString::number( sms->Type() )
			);
			switch( sms->Type() ){
				case c_SMS::REC_UNREAD:
					item->setPixmap ( 1, * ( mainWidget->pl1->pixmap() ) );
					break;
				case c_SMS::REC_READ:
					item->setPixmap ( 1, * ( mainWidget->pl2->pixmap() ) );
					break;
				case c_SMS::STO_SENT:
					item->setPixmap ( 1, * ( mainWidget->pl4->pixmap() ) );
					break;
				case c_SMS::STO_UNSENT:
					item->setPixmap ( 1, * ( mainWidget->pl3->pixmap() ) );
					break;
			}
		} i++;
		++it;
	}
}
