/***************************************************************************
                       kmfruleedit.cpp  -  description
                          -------------------
 begin                : Thu Feb 7  2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : a9806056@unet.univie.ac.at
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kmfruleedit.h"


//QT includes
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qheader.h>
#include <qsplitter.h>

#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qptrlist.h>
#include <qstring.h> 
#include <qinputdialog.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qgroupbox.h>
#include <qsize.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qwidgetstack.h> 

//KDE includes
#include <kled.h>
#include <kdebug.h>
#include <klocale.h>
#include <klistview.h>
#include <kpopupmenu.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kpushbutton.h>

// project includes
#include "kmfchainedit.h"
#include "kmfruleeditip.h"
#include "kmfruleeditmac.h"
#include "kmfruleeditorinterface.h"
#include "kmfruleeditorprotocol.h"
#include "kmfruleeditorstate.h"
#include "kmfruleeditorlimit.h"
#include "kmfruleeditortos.h"
#include "kmfruleedittargetlog.h"
#include "kmfruleeditortargetnat.h"
#include "kmfruleedittargetmark.h"
#include "kmfruleeditcustomopt.h"
#include "kmfruleinfo.h"

#include "../core/kmfdoc.h"
#include "../core/iptchain.h"
#include "../core/iptrule.h"
#include "../kmfrulelvitem.h"
#include "../kmfchainlvitem.h"
#include "kmfoutputviewer.h"
#include "../core/kmfcheckinput.h"
#include "../core/kmferror.h"
#include "../core/kmferrorhandler.h"

KMFRuleEdit::KMFRuleEdit( QWidget* parent, const char* name, WFlags fl )
		: KMyFirewallRuleEditor( parent, name, fl ) {
	if ( !name )
		setName( "KMFRuleEdit" );
	loadIcons();
	b_move_up->setPixmap( icon_up );
	b_move_down->setPixmap( icon_down );

	m_err = new KMFError();
	m_err_handler = new KMFErrorHandler( "KMFRuleEdit" );
	kb_optSelect->clear();
	kb_optSelect->insertItem( i18n( "Edit IP Options" ) );
	kb_optSelect->insertItem( i18n( "Edit MAC Options" ) );
	kb_optSelect->insertItem( i18n( "Edit Protocol Options" ) );
	kb_optSelect->insertItem( i18n( "Edit Interface Options" ) );
	kb_optSelect->insertItem( i18n( "Edit Statfeul Inspection" ) );
	kb_optSelect->insertItem( i18n( "Edit Limit Matches" ) );
	kb_optSelect->insertItem( i18n( "Edit TOS Options" ) );
	kb_optSelect->insertItem( i18n( "Edit Custom Options" ) );
	kb_optSelect->insertItem( i18n( "Edit Target Options" ) );
	connect( kb_optSelect, SIGNAL( activated( int ) ) , this, SLOT( slotNewOptionType( int ) ) );

	lv_rules = new KListView( m_widgetStack, "lv_rules" );
	lv_rules->addColumn( i18n( "Rule No." ) );
	lv_rules->addColumn( QString::null );
	lv_rules->addColumn( i18n( "Value" ) );
	lv_rules->setSizePolicy( QSizePolicy( ( QSizePolicy::SizeType ) 2, ( QSizePolicy::SizeType ) 2, 0, 0, lv_rules->sizePolicy().hasHeightForWidth() ) );
	lv_rules->setFrameShape( KListView::StyledPanel );
	lv_rules->setFrameShadow( KListView::Sunken );
	lv_rules->setSorting( -1, false );
	lv_rules->setFullWidth();
	lv_rules->setItemsMovable( true );
	//  lv_rules->setAcceptDrops(true);
	lv_rules->setDropHighlighter( true );
	lv_rules->setDropVisualizer( true );
	lv_rules->setSelectionMode( QListView::Single );
	lv_rules->show();
	m_widgetStack->addWidget( lv_rules, 0 );
	m_splitter->setResizeMode( gb_options, QSplitter::KeepSize );

	m_iped = new KMFRuleEditIP( m_widgetStack, "IPEditor", 0 /*,curr_rule*/ );
	connect( m_iped, SIGNAL( sigAddRuleOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddRuleOption( QString*, QPtrList<QString>* ) ) );
	connect( m_iped, SIGNAL( sigDelRuleOpt( QString* ) ), this, SLOT( slotDelRuleOption( QString* ) ) );
	connect( m_iped, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_iped, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );

	m_iped->show();
	m_widgetStack->addWidget( m_iped, 1 );

	m_maced = new KMFRuleEditMac( m_widgetStack, "IPEditor", 0 /*,curr_rule*/ );
	connect( m_maced, SIGNAL( sigAddRuleOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddRuleOption( QString*, QPtrList<QString>* ) ) );
	connect( m_maced, SIGNAL( sigDelRuleOpt( QString* ) ), this, SLOT( slotDelRuleOption( QString* ) ) );
	connect( m_maced, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_maced, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_maced->show();
	m_widgetStack->addWidget( m_maced, 2 );

	m_proted = new KMFRuleEditorProtocol( this, "IntEditor", 0 /*,curr_rule*/ );
	connect( m_proted, SIGNAL( sigAddRuleOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddRuleOption( QString*, QPtrList<QString>* ) ) );
	connect( m_proted, SIGNAL( sigDelRuleOpt( QString* ) ), this, SLOT( slotDelRuleOption( QString* ) ) );
	connect( m_proted, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_proted, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_proted->show();
	m_widgetStack->addWidget( m_proted, 3 );

	m_inted = new KMFRuleEditorInterface( this, "IntEditor", 0 /*,curr_rule*/ );
	connect( m_inted, SIGNAL( sigAddRuleOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddRuleOption( QString*, QPtrList<QString>* ) ) );
	connect( m_inted, SIGNAL( sigDelRuleOpt( QString* ) ), this, SLOT( slotDelRuleOption( QString* ) ) );
	connect( m_inted, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_inted, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_inted->show();
	m_widgetStack->addWidget( m_inted, 4 );

	m_stateed = new KMFRuleEditorState( this, "IntEditor", 0 /*,curr_rule*/ );
	connect( m_stateed, SIGNAL( sigAddRuleOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddRuleOption( QString*, QPtrList<QString>* ) ) );
	connect( m_stateed, SIGNAL( sigDelRuleOpt( QString* ) ), this, SLOT( slotDelRuleOption( QString* ) ) );
	connect( m_stateed, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_stateed, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_stateed->show();
	m_widgetStack->addWidget( m_stateed, 5 );

	m_limited = new KMFRuleEditorLimit( this, "IntEditor", 0 /*,curr_rule*/ );
	connect( m_limited, SIGNAL( sigAddRuleOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddRuleOption( QString*, QPtrList<QString>* ) ) );
	connect( m_limited, SIGNAL( sigDelRuleOpt( QString* ) ), this, SLOT( slotDelRuleOption( QString* ) ) );
	connect( m_limited, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_limited, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_limited->show();
	m_widgetStack->addWidget( m_limited, 6 );

	m_tosed = new KMFRuleEditorTos( this, "IntEditor", 0 );
	connect( m_tosed, SIGNAL( sigAddRuleOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddRuleOption( QString*, QPtrList<QString>* ) ) );
	connect( m_tosed, SIGNAL( sigDelRuleOpt( QString* ) ), this, SLOT( slotDelRuleOption( QString* ) ) );
	connect( m_tosed, SIGNAL( sigAddTargetOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddTargetOption( QString*, QPtrList<QString>* ) ) );
	connect( m_tosed, SIGNAL( sigDelTargetOpt( QString* ) ), this, SLOT( slotDelTargetOption( QString* ) ) );
	connect( m_tosed, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_tosed, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_tosed->show();
	m_widgetStack->addWidget( m_tosed, 7 );

	m_tglog = new KMFRuleEditTargetLog( this, "IntEditor", 0 );
	connect( m_tglog, SIGNAL( sigAddTargetOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddTargetOption( QString*, QPtrList<QString>* ) ) );
	connect( m_tglog, SIGNAL( sigDelTargetOpt( QString* ) ), this, SLOT( slotDelTargetOption( QString* ) ) );
	connect( m_tglog, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_tglog, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_tglog ->show();
	m_widgetStack->addWidget( m_tglog, 8 );

	m_tgnat = new KMFRuleEditorTargetNat( this, "SnatEditor", 0 );
	connect( m_tgnat, SIGNAL( sigAddTargetOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddTargetOption( QString*, QPtrList<QString>* ) ) );
	connect( m_tgnat, SIGNAL( sigDelTargetOpt( QString* ) ), this, SLOT( slotDelTargetOption( QString* ) ) );
	connect( m_tgnat, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_tgnat, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_tgnat ->setMode( true );
	m_tgnat ->show();
	m_widgetStack->addWidget( m_tgnat, 9 );

	m_tgmark = new KMFRuleEditTargetMark( this, "MarkEditor", 0 );
	connect( m_tgmark, SIGNAL( sigAddTargetOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddTargetOption( QString*, QPtrList<QString>* ) ) );
	connect( m_tgmark, SIGNAL( sigDelTargetOpt( QString* ) ), this, SLOT( slotDelTargetOption( QString* ) ) );
	connect( m_tgmark, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_tgmark, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_widgetStack->addWidget( m_tgmark, 10 );

	m_editchain = new KMFChainEdit( this, "chianditor", 0 );
	kdDebug() << "CONNECTING CHAINEDITOR" << endl;
	connect( m_editchain, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_editchain, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );

	m_widgetStack->addWidget( m_editchain, 11 );

	m_output_viewer = new KMFOutputViewer( this, "m_output_viewer" );
	connect( m_output_viewer, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );

	m_custom_opt = new KMFRuleEditCustomOpt( this, "customOpt" );
	kdDebug() << "CONNECTING CUSTOM OPTIONS" << endl;
	connect( m_custom_opt, SIGNAL( sigAddRuleOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddRuleOption( QString*, QPtrList<QString>* ) ) );
	connect( m_custom_opt, SIGNAL( sigDelRuleOpt( QString* ) ), this, SLOT( slotDelRuleOption( QString* ) ) );
	connect( m_custom_opt, SIGNAL( sigAddTargetOpt( QString*, QPtrList<QString>* ) ), this, SLOT( slotAddTargetOption( QString*, QPtrList<QString>* ) ) );
	connect( m_custom_opt, SIGNAL( sigDelTargetOpt( QString* ) ), this, SLOT( slotDelTargetOption( QString* ) ) );
	connect( m_custom_opt, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_custom_opt, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );

	m_widgetStack->addWidget( m_custom_opt, 12 );

	m_rule_info = new KMFRuleInfo( this, "rule info" );
	connect( m_rule_info, SIGNAL( sigDocumentChanged() ), this, SLOT( slotReloadDocument() ) );
	connect( m_rule_info, SIGNAL( sigHideMe() ), this, SLOT( slotShowOverview() ) );
	m_widgetStack->addWidget( m_rule_info, 13 );

	KMyFirewall *app = dynamic_cast<KMyFirewall *>( parent );
	if ( app ) {
		m_output_viewer->loadApp( app );
		m_output_viewer->show();
		connect( m_output_viewer, SIGNAL( sigStatusChanged() ), app, SLOT( slotCheckStatus() ) );
		m_widgetStack->addWidget( m_output_viewer, 14 );
	} else {
		const QString& msg = i18n( "<b>KMFOutputViewer: parent* is not of a KMyFirewall pointer.<b>" );
		m_err->setErrType( "FATAL" );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
	}
//	m_widgetStack->raiseWidget( 0 );
	m_table = new QString( "filter" );

	m_check_input = new KMFCheckInput();
	curr_rule_options = new QPtrList<QString>;
	m_curr_chains = new QStringList();
	m_curr_chain_name = "UNDEFINED";
	//	m_curr_rule_item = 0;
	m_contextMenu = new KPopupMenu( lv_rules );

	connect( lv_rules, SIGNAL( contextMenuRequested ( QListViewItem*, const QPoint&, int ) ),
	         this, SLOT( slotRuleRBM( QListViewItem*, const QPoint&, int ) ) );

	connect( lv_rules, SIGNAL( itemRenamed ( QListViewItem*, int, const QString& ) ),
	         this, SLOT( slotRenameRule( QListViewItem*, int, const QString& ) ) );

	connect( lv_rules, SIGNAL( clicked( QListViewItem*, const QPoint&, int ) ),
	         this, SLOT( slotEditRule( QListViewItem*, const QPoint&, int ) ) );

	connect( lv_rules, SIGNAL( returnPressed( QListViewItem * ) ),
	         this, SLOT( slotEditRule( QListViewItem* ) ) );

	connect( cb_log_rule, SIGNAL( clicked() ), this, SLOT( slotLogRuleChanged() ) );
	connect( cb_disable_rule, SIGNAL( clicked() ), this, SLOT( slotEnableRuleChanged() ) );

	m_rule = 0;
	m_chain = 0;
	kmfdoc = 0;
	m_curr_rule_number = -1;
	slotNewTableSelected();
	m_widgetStack->show();
	slotShowOverview();
	show();
}

KMFRuleEdit::~KMFRuleEdit() {}

void KMFRuleEdit::loadDoc( KMFDoc* doc ) {
	kdDebug() << "void KMFRuleEdit::loadDoc(KMFDoc* doc)" << endl;
	resetLeds();
	if ( doc == 0 ) {
		m_err->setErrType( "NORMAL" );
		const QString& msg = i18n( "KMFRuleEdit:::loadDoc(KMFDoc* doc)\n"
		                           "KMFDoc* doc == 0. This is a bug." );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
		setEnabled( false );
		return ;
	}
	if ( !isEnabled() )
		setEnabled( true );
	kmfdoc = doc;
	rb_filter->setEnabled( kmfdoc->useFilter() );
	rb_mangle->setEnabled( kmfdoc->useMangle() );
	rb_nat->setEnabled( kmfdoc->useNat() );
	if ( kmfdoc->useModules() ) {
		m_led_modules->setColor( green );
		m_led_modules->on();
	} else {
		m_led_modules->setColor( red );
		m_led_modules->off();
	}

	if ( kmfdoc->useIPFwd() ) {
		m_led_fwd->setColor( green );
		m_led_fwd->on();
	} else {
		m_led_fwd->setColor( red );
		m_led_fwd->off();
	}

	if ( kmfdoc->useSynCookies() ) {
		m_led_syn->setColor( green );
		m_led_syn->on();
	} else {
		m_led_syn->setColor( red );
		m_led_syn->off();
	}

	if ( kmfdoc->useRPFilter() ) {
		m_led_rp->setColor( green );
		m_led_rp->on();
	} else {
		m_led_rp->setColor( red );
		m_led_rp->off();
	}

	if ( kmfdoc->useMartians() ) {
		m_led_martians->setColor( green );
		m_led_martians->on();
	} else {
		m_led_martians->setColor( red );
		m_led_martians->off();
	}
	enableEdit( false );
	slotNewTableSelected();
	slotShowOverview();
	emit sigDocumentChanged();
}

void KMFRuleEdit::slotLoadDocument( KMFDoc* doc ) {
	kdDebug() << "KMFRuleEdit::slotLoadDocument( KMFDoc* doc )" << endl;
	slotShowOverview();
	loadDoc( doc );
}
void KMFRuleEdit::slotReloadDocument() {
	kdDebug() << "KMFRuleEdit::slotReloadDocument()( KMFDoc* doc )\nSTARTING: UPDATE" << endl;
	slotShowOverview();
	loadDoc( kmfdoc );
	kdDebug() << "UPDATE FINISHED." << endl;
}

void KMFRuleEdit::slotNewTableSelected() {
	kdDebug() << "void KMFRuleEdit::slotNewTableSelected()" << endl;
	if ( kmfdoc == 0 ) {
		setEnabled( false );
		return ;
	}
	resetLeds();
	slotShowOverview();
	cb_chain->clear();
	lv_rules->clearSelection();
	lv_rules->clear();

	QString table = "filter";
	if ( !rb_filter->isEnabled() )
		rb_filter->setChecked( false );
	if ( !rb_nat->isEnabled() )
		rb_nat->setChecked( false );
	if ( !rb_mangle->isEnabled() )
		rb_mangle->setChecked( false );


	if ( rb_filter->isChecked() && rb_filter->isEnabled() ) {
		setEnabled( true );
		table = "filter";
	} else if ( rb_nat->isChecked() && rb_nat->isEnabled() ) {
		setEnabled( true );
		table = "nat";
	} else if ( rb_mangle->isChecked() && rb_mangle->isEnabled() ) {
		setEnabled( true );
		table = "mangle";
	} else {
		if ( rb_filter->isEnabled() )
			rb_filter->setChecked( true );
		else if ( rb_nat->isEnabled() )
			rb_nat->setChecked( true );
		else if ( rb_mangle->isEnabled() )
			rb_mangle->setChecked( true );
		else {
			setEnabled( false );
			return ;
		}
	}

	IPTable *tab = kmfdoc->table( table );
	if ( tab == 0 ) {
		setEnabled( false );
		kdDebug() << "Table: " << table << " not found in document!!" << table << endl;
		return ;
	}

	slotFillChainCB( *tab );

	if ( *m_table != table ) {
		m_curr_rule_number = -1;
	}


	if ( m_chain != 0 ) {
		uint i = 0;
		for ( QStringList::ConstIterator it = m_curr_chains->begin();
		      it != m_curr_chains->end(); ++it, ++i ) {
			if ( *it == m_curr_chain_name ) {
				cb_chain->setCurrentItem( i );
				m_chain = kmfdoc->chain( m_curr_chain_name, table );
			}
		}
	}
	else
		m_curr_chain_name = m_curr_chains->first();

	m_table = new QString( table );

	if ( !m_curr_chain_name.isEmpty() )
		slotNewChainSelected( m_curr_chain_name );
	else
		slotNewChainSelected( "" );
}

void KMFRuleEdit::slotNewChainSelected( int index ) {
	kdDebug() << "KMFRuleEdit::slotNewChainSelected(int)" << endl;

	if ( index > -1 ) {
		m_curr_chain_name = (*m_curr_chains)[ index ];
		if ( !m_curr_chain_name.isEmpty() )
			slotNewChainSelected( m_curr_chain_name );
	}
}

void KMFRuleEdit::slotNewChainSelected( const QString& na ) {
	kdDebug() << "KMFRuleEdit::slotNewChainSelected(const QString& na)" << endl;
	resetLeds();
  slotShowOverview();
//	slotShowOverview();
	QString& table = *m_table;
	kdDebug() << "Selected Chain: " << na << endl;

	IPTable* tab = kmfdoc->table( table );
	if ( tab == 0 ) {
		kdDebug() << "Table: " << table << " not found in Ruleset" << endl;
		enableEdit( false );
		return ;
	}

	//	slotFillChainCB( *tab );

	QPtrList<IPTChain> tmp_chainset = tab->chains();
	lv_rules->clear();

	IPTChain* tmp_chain;
	QString chain_name;

	if ( tmp_chainset.count() == 0 )
		enableEdit( false );

	for ( tmp_chain = tmp_chainset.first(); tmp_chain; tmp_chain = tmp_chainset.next() ) {
		chain_name = tmp_chain->name();
		if ( chain_name == na ) {
			m_chain = tmp_chain;
			kdDebug() << "Found Chain " << na << " in Ruleset." << endl;
			slotAddValidTargets( *m_chain );
			m_top_item = new KMFChainLVItem( lv_rules, 0, m_chain );

			m_top_item->setupView();
			m_top_item->setText( 0, i18n( "Table:" ) );
			m_top_item->setOpen( true );

			KMFRuleLVItem *tmp_item = 0;

			const QPtrList<IPTRule>& rules = m_chain->chainRuleset();
			if ( rules.count() == 0 )
				enableEdit( false );

			if ( m_curr_chain_name == na ) {
				if ( m_curr_rule_number > -1 ) {
					tmp_item = m_top_item->getRuleItemNumber( m_curr_rule_number );
					if ( tmp_item == 0 )
						return ;
				}
			} else {
				m_curr_chain_name = na;
				tmp_item = m_top_item->getFirstRuleItem();
				m_curr_rule_number = -1;
			}

			if ( tmp_item == 0 ) {
				m_curr_rule_number = -1;
				enableEdit( false );
				return ;
			} else {
				m_curr_rule_item = tmp_item;
				m_rule = tmp_item->rule();
				slotUpdatePreview( true );
			}
			m_top_item->setRuleItemOpen( true );
		}
	}
}

void KMFRuleEdit::slotNewRuleSelected( QListViewItem* item ) {
	kdDebug() << "KMFRuleEdit::slotNewRuleSelected(QListViewItem* item)" << endl;
	if ( item ) {
		if ( KMFRuleLVItem * curr_rule_item = dynamic_cast<KMFRuleLVItem *>( item ) ) {
			bool isSelected = updateCurrRule();
			if ( isSelected ) {
				slotUpdatePreview( false );
			}
		} else if ( KMFChainLVItem * curr_chain_item = dynamic_cast<KMFChainLVItem *>( item ) ) {
			m_chain = curr_chain_item->chain();
			bool isSelected = updateCurrRule();
			if ( isSelected ) {
				slotUpdatePreview( false );
			}
		}
	}
}

bool KMFRuleEdit::updateCurrRule() {
	kdDebug() << "KMFRuleEdit::updateCurrRule()" << endl;
	if ( m_rule != 0 && m_curr_rule_item ) {
		m_chain = m_rule->chain();
		enableEdit( true );
		showRuleOptionLeds( *m_rule );
		return true;
	} else {
		enableEdit( false );
		return false;
	}
	return false;
}


void KMFRuleEdit::slotUpdatePreview( bool reload_rule ) {
	kdDebug() << "void KMFRuleEdit::slotUpdatePreview(bool reload_rule)" << endl;
	m_curr_rule_item = m_top_item->getRuleItemNumber( m_curr_rule_number );
	if ( m_curr_rule_item )
		m_rule = m_curr_rule_item->rule();

	if ( !m_curr_rule_item || !m_rule ) {
		enableEdit( false );
		return ;
	} else {
		enableEdit( true );
	}

	if ( !reload_rule ) {
		showRuleOptionLeds( *m_rule );
	} else {
		bool haveone = false;
		haveone = updateCurrRule();
		if ( haveone ) {
			showRuleOptionLeds( *m_rule );
		}
	}
}

void KMFRuleEdit::slotFillChainCB( const IPTable& table ) {
	QPtrList<IPTChain> chains = table.chains();
	if ( chains.count() < 1 ) {
		kdDebug() << "No Chains in table: " << table.name() << endl;
		return ;
	}
	IPTChain* ch;
	m_curr_chains->clear();
	cb_chain->clear();
	if ( *m_table != table.name() ) {
		m_curr_rule_number = -1;
	}
	int num_rules = 0;
	for ( ch = chains.first(); ch != 0; ch = chains.next() ) {
		const QString & na = ch->name();
		const QString& ta = table.name();
		//        kdDebug() << "Found Chain: " << na << endl;
		if ( table.name() == ta ) {
			m_curr_chains->append( na );
			num_rules = ch->chainRuleset().count();
			QString chain = i18n( "%1 (%2 Rules)" ).arg( na ).arg( num_rules );
			cb_chain->insertItem( chain );
		}
	}
}

void KMFRuleEdit::slotAddValidTargets( const IPTChain& chain ) {
	kdDebug() << "KMFRuleEdit::slotAddValidTargets( const IPTChain& chain )" << endl;
	const QString& table = chain.table() ->name();
	const QString& name = chain.name();
	if ( table.isEmpty() || name.isEmpty() ) {
		kdDebug() << "KMFRuleEdit::slotAddValidTargets( const IPTChain& chain ): ERROR: name or table not found in table" << endl;
		return ;
	}
	cb_target->clear();
	// general Targets
	cb_target->insertItem( "ACCEPT" );
	cb_target->insertItem( "DROP" );
	cb_target->insertItem( "LOG" );
	cb_target->insertItem( "QUEUE" );
	cb_target->insertItem( "RETURN" );
	if ( name == "INPUT" || name == "OUTPUT" || name == "FORWARD" )
		cb_target->insertItem( "REJECT" );

	if ( name == "INPUT" || name == "OUTPUT" || name == "PREROUTING" )
		cb_target->insertItem( "MIRROR" );

	if ( table == "nat" && name == "POSTROUTING" )
		cb_target->insertItem( "SNAT" );

	if ( table == "nat" && ( name == "PREROUTING" || name == "OUTPUT" ) ) {
		cb_target->insertItem( "DNAT" );
		cb_target->insertItem( "REDIRECT" );
	}

	if ( table == "nat" && name == "POSTROUTING" )
		cb_target->insertItem( "MASQUERADE" );

	if ( table == "mangle" ) {
		cb_target->insertItem( "MARK" );
		cb_target->insertItem( "TOS" );
	}


	if ( table == "filter" || table == "nat" || table == "mangle" ) {
		QPtrList<IPTChain> tmp_chains = kmfdoc->chains( table );
		for ( uint i = 0;i < tmp_chains.count();i++ ) {
			IPTChain* tmp_ch = tmp_chains.at( i );
			if ( !tmp_ch->isBuildIn() && tmp_ch->name() != name ) {
				kdDebug() << "Adding Chain: " << tmp_ch->name() << "  to Targets. " << endl;
				cb_target->insertItem( tmp_ch->name() );
			}
		}
	}
}


void KMFRuleEdit::slotAddRule() {
	kdDebug() << "KMFRuleEdit::slotAddRule()" << endl;
	bool ok = FALSE;
	const QString greeting = i18n( "New Rule" );
	const QString label = i18n( "Please enter a name for the new rule:" );
	QString text = QInputDialog::getText( greeting, label, QLineEdit::Normal, QString::null, &ok, this, "dsa" );
	if ( ok && !text.isEmpty() ) {
		kdDebug() << "Adding Rule Named: " << text << endl;
		QString ch = m_chain->name();
		kdDebug() << "For Chain: " << ch << endl;
		QString tab = m_chain->table() ->name();
		kdDebug() << "In Table: " << tab << endl;
		QString target = "ACCEPT";
		kdDebug() << "With Target: " << target << endl;
		if ( !text.isEmpty() && !ch.isEmpty() && !tab.isEmpty() && !target.isEmpty() ) {
			if ( m_err_handler->showError( m_check_input->checkInput( text, "RULENAME" ) ) ) {
				kmfdoc->addRule( text, ch, tab, target );
				kmfdoc->changed();
				slotReloadDocument();
			}
		} else {
			KMessageBox::sorry( this,
			                      i18n( "An error occurred while trying to setup a new rule." ), i18n( "Rule Editor" )
			                    );
		}
	}
}



void KMFRuleEdit::slotEditRule( QListViewItem* item, const QPoint&, int ) {
	if ( item )
		if ( KMFRuleLVItem * tmp_item = dynamic_cast<KMFRuleLVItem *>( item ) ) {
			if ( tmp_item == 0 )
				return ;
			m_rule = tmp_item->rule();
			m_chain = m_rule->chain();
			m_curr_rule_item = currRuleParentItem();
			slotEditRule();
		}
}

void KMFRuleEdit::slotEditRule( QListViewItem* item ) {
	if ( item )
		if ( KMFRuleLVItem * tmp_item = dynamic_cast<KMFRuleLVItem *>( item ) ) {
			if ( tmp_item == 0 )
				return ;
			m_rule = tmp_item->rule();
			m_chain = m_rule->chain();
			m_curr_rule_item = currRuleParentItem();
			slotEditRule();
		} else if ( KMFChainLVItem * tmp_item = dynamic_cast<KMFChainLVItem *>( item ) ) {
			if ( tmp_item == 0 )
				return ;
			m_rule = 0;
			m_chain = tmp_item->chain();
// 			m_curr_rule_item = currRuleParentItem();
			slotEditRule();
		}
}

void KMFRuleEdit::slotDelChain() {
	kdDebug() << "void KMFView::slotDelChain()" << endl;
	if ( ! m_chain ) {
		KMessageBox::sorry( this, i18n("<qt><b>Sorry, don't know which Chain shouold"
														" be deleted!</b><br>Make shure thaqt you select a"
														"Chain or a Rule first by clicking on it.</qt>"), i18n("No Chain selected") );
		return;
	}
	int doit = KMessageBox::questionYesNo ( this , i18n( "<p>Are you sure that you want to delete "
	                                        "chain: <b>%1</b> from table: <b>%2</b>?"
	                                        "<p>By deleting the chain all rules that belong "
	                                        "to the chain will be deleted too."
	                                        "<p>Please note there is no way to undo the delete." ).arg( m_chain->name() ).arg( m_chain->table()->name() ),
	                                        i18n( "Delete Chain" ), KStdGuiItem::yes(), KStdGuiItem::no(), "main_view_delete_chain" );
	kdDebug() << "Message Box returned: " << doit << endl;
	if ( doit == 3 ) {
		kdDebug() << "Try to delete Chain" << endl;
		m_err = kmfdoc->delChain( m_chain );
		kmfdoc->changed();
		if ( m_err_handler ->showError( m_err ) ) {
			slotReloadDocument();
		}
	}
}

void KMFRuleEdit::slotEditRule() {
	bool haveone = false;
	haveone = updateCurrRule();
	if ( haveone ) {
		kb_optSelect->setEnabled( true );
		cb_log_rule ->setEnabled( true );
		cb_disable_rule ->setEnabled( true );
		cb_target ->setEnabled( true );
		cb_frag ->setEnabled( true );
		//*********************************
		enableEdit( true );
	}
}

void KMFRuleEdit::enableEdit( bool on ) {
	if ( on ) {
		l_editing_rule->setText( "<b>" + m_rule->name() + "</b>" );
		m_curr_rule_number = m_rule->ruleNum();
		if ( m_curr_rule_item && m_rule != 0 ) {
			m_curr_rule_item -> clearView();
			m_curr_rule_item -> setupView();
			m_curr_rule_item -> setOpen( true );
			m_curr_rule_item -> setSelected( true );
			lv_rules->setCurrentItem( m_curr_rule_item );
		}
		b_move_up->setEnabled( true );
		b_move_down->setEnabled( true );
		m_iped->setEnabled( true );
		m_maced->setEnabled( true );
		m_proted->setEnabled( true );
		m_inted->setEnabled( true );
		m_stateed->setEnabled( true );
		m_limited->setEnabled( true );
		m_tosed->setEnabled( true );
		m_tglog->setEnabled( true );
		m_tgnat->setEnabled( true );
		m_tgmark->setEnabled( true );
		kb_optSelect->clear();
		kb_optSelect->insertItem( i18n( "Edit IP Options" ) );
		kb_optSelect->insertItem( i18n( "Edit MAC Options" ) );
		kb_optSelect->insertItem( i18n( "Edit Protocol Options" ) );
		kb_optSelect->insertItem( i18n( "Edit Interface Options" ) );
		kb_optSelect->insertItem( i18n( "Edit Statfeul Inspection" ) );
		kb_optSelect->insertItem( i18n( "Edit Limit Matches" ) );
		kb_optSelect->insertItem( i18n( "Edit TOS Options" ) );
		kb_optSelect->insertItem( i18n( "Edit Custom Options" ) );
		QString target = m_rule->target();
		if ( target == "LOG" || target == "SNAT" || target == "DNAT" || target == "TOS" ||
			target == "REJECT" || target ==  "REJECTTYPE" || target == "MARK" ) {
			kb_optSelect->insertItem( i18n( "Edit Target Options" ) );
		}
		kb_optSelect->setEnabled( true );
		cb_log_rule ->setEnabled( true );
		cb_disable_rule ->setEnabled( true );
		cb_target ->setEnabled( true );
		cb_frag ->setEnabled( true );
	} else {
		l_editing_rule->setText( i18n( "No Rule Selected" ) );
		kb_optSelect->setEnabled( false );
		b_move_up->setEnabled( false );
		b_move_down->setEnabled( false );
		m_iped->setEnabled( false );
		m_maced->setEnabled( false );
		m_proted->setEnabled( false );
		m_inted->setEnabled( false );
		m_stateed->setEnabled( false );
		m_limited->setEnabled( false );
		m_tosed->setEnabled( false );
		m_tglog->setEnabled( false );
		m_tgnat->setEnabled( false );
		m_tgmark->setEnabled( false );
		cb_log_rule ->setEnabled( false );
		cb_disable_rule ->setEnabled( false );
		cb_target ->setEnabled( false );
		cb_frag ->setEnabled( false );
	}
}

void KMFRuleEdit::slotMoveRuleDown() {
	kdDebug() << "KMFRuleEdit::slotMoveRuleDown()" << endl;
	if ( m_rule != 0 && kb_optSelect->isEnabled() ) {
		IPTChain * parent_chain = m_rule->chain();
		//        kdDebug() << "Rule belongs to Chain:" << *parent_chain->name() << endl;
		const QString& identifier = m_curr_rule_item->text( 2 );
		kdDebug() << "Rule identifier: " << identifier << endl;
		if ( parent_chain->moveRule( m_rule, 1 ) ) {
			m_curr_rule_number = m_rule->ruleNum();
			kmfdoc->changed();
			slotNewChainSelected( m_curr_chain_name );
			lv_rules->setSelected( lv_rules->findItem( identifier , 2 ), true );
		}
	}
}

void KMFRuleEdit::slotMoveRuleUp() {
	kdDebug() << "KMFRuleEdit::slotMoveRuleUp()" << endl;
	if ( m_rule != 0 && kb_optSelect->isEnabled() ) {
		IPTChain * parent_chain = m_rule->chain();
		//        kdDebug() << "Rule belongs to Chain:" << *parent_chain->name() << endl;
		const QString& identifier = m_curr_rule_item->text( 2 );
		kdDebug() << "Rule identifier: " << identifier << endl;
		if ( parent_chain->moveRule( m_rule, -1 ) ) {
			m_curr_rule_number = m_rule->ruleNum();
			kmfdoc->changed();
			slotNewChainSelected( m_curr_chain_name );
			lv_rules->setSelected( lv_rules->findItem( identifier , 2 ), true );
		}
	}
}
void KMFRuleEdit::resetLeds() {
	// reset all leds
	led_ip_opt->setState( KLed::Off );
	led_mac_opt->setState( KLed::Off );
	led_prot_opt->setState( KLed::Off );
	led_state_opt->setState( KLed::Off );
	led_limit_opt->setState( KLed::Off );
	led_int_opt->setState( KLed::Off );
	led_tos_opt->setState( KLed::Off );
	led_target_opt->setState( KLed::Off );
	cb_frag->setChecked( false );
	cb_frag_inv->setChecked( false );
}

void KMFRuleEdit::showRuleOptionLeds( const IPTRule& curr_rule ) {
	kdDebug() << "KMFRuleEdit::showRuleOptionLeds(IPTRule& curr_rule)" << endl;
	resetLeds();
	//+++++++++++++++++++++++++++++++++++
	QPtrList<QPtrList<QString> >& options = curr_rule.ruleOptions();
	QString target = curr_rule.target();
	cb_target->setCurrentText( target );

	if ( !curr_rule.enabled() )
		cb_disable_rule->setChecked( true );
	else
		cb_disable_rule->setChecked( false );

	if ( curr_rule.logging() )
		cb_log_rule->setChecked( true );
	else
		cb_log_rule->setChecked( false );

	QPtrList<QPtrList<QString> >& target_options = curr_rule.ruleTargetOptions();
	if ( !target_options.isEmpty() )
		led_target_opt->setState( KLed::On );


	if ( !options.isEmpty() ) {
		//   	kdDebug() << "There are options defined for the rule " << endl;
		QPtrList<QString>* option_values;
		for ( option_values = options.first(); option_values; option_values = options.next() ) {
			if ( !option_values->isEmpty() ) {
				QString opt_str = *option_values->at( 0 );
				//     		kdDebug() << "Found Option: " << opt_str << endl;
				QString opt = opt_str;
				//				kdDebug() << "Found Option Name: " << opt << endl;
				if ( opt == "tcp" || opt == "udp" || opt == "icmp" || opt == "all_prot" ||
				        opt == "udp_src_multiport" || opt == "udp_dest_multiport" || opt == "udp_equal_multiport" ||
				        opt == "tcp_src_multiport" || opt == "tcp_dest_multiport" || opt == "tcp_equal_multiport" ) {
					led_prot_opt->setState( KLed::On );
				} else if ( opt == "src_ip" || opt == "dest_ip" ) {
					led_ip_opt->setState( KLed::On );
				} else if ( opt == "mac" ) {
					led_mac_opt->setState( KLed::On );
				} else if ( opt == "state" ) {
					led_state_opt->setState( KLed::On );
				} else if ( opt == "limit" ) {
					led_limit_opt->setState( KLed::On );
				} else if ( opt == "tos" ) {
					led_tos_opt->setState( KLed::On );
				} else if ( opt == "frag" ) {
					cb_frag->setChecked( true );
					if ( option_values->count() > 1 && !option_values->at( 1 ) ->isNull() ) {
						if ( option_values->at( 1 ) ->startsWith( "! " ) ) {
							cb_frag_inv->setChecked( true );
						}
					}
				} else if ( opt == "in_int" || opt == "out_int" ) {
					led_int_opt->setState( KLed::On );
				}
			}
		}
	}
}

void KMFRuleEdit::slotDelRule() {
	kdDebug() << "KMFRuleEdit::slotDelRule()" << endl;
	bool isSelected = updateCurrRule();
	if ( isSelected ) {
		int doit = KMessageBox::questionYesNo ( this , i18n( "<p>Are you sure that you want to delete "
		                                        "rule: <b>%1</b> from chain: <b>%2</b>?"
		                                        "<p>Please note there is no way to undo the delete." ).arg( m_rule->name() ).arg( m_rule->chain() ->name() ),
		                                        i18n( "Delete Rule" ), KStdGuiItem::yes(), KStdGuiItem::no(), "rule_edit_delete_rule" );
		kdDebug() << "Message Box returned: " << doit << endl;
		if ( doit == 3 ) { // OK clicked
			kdDebug() << "clicked ok" << endl;
			kmfdoc->delChainRule( *m_rule );
			kmfdoc->changed();
			m_curr_rule_number--;
			if ( m_curr_rule_number < 0 )
				m_curr_rule_number = -1;
			slotReloadDocument();
		}
	}
}

void KMFRuleEdit::slotShowOverview() {
  kdDebug() << "\nKMFRuleEdit::slotShowOverview()\n" << endl;
	m_widgetStack->raiseWidget( 0 );
}

void KMFRuleEdit::slotNewOptionType( int index ) {
	kdDebug() << "KMFRuleEdit::slotNewOptionType( index " << index << " )" << endl;
	if ( index > -1 ) {
		switch ( index ) {
			case 0:
				slotEditIPopt();
				break;
			case 1:
				slotEditMacOpt();
				break;
			case 2:
				slotEditProtOpt();
				break;
			case 3:
				slotEditIntOpt();
				break;
			case 4:
				slotEditStateOpt();
				break;
			case 5:
				slotEditLimitOpt();
				break;
			case 6:
				slotEditTosOpt();
				break;
			case 7:
				slotEditCustomOpt();
				break;
			case 8:
				slotEditTargetOption();
				break;
		}
	}
}

void KMFRuleEdit::slotEditIPopt() {
	kdDebug() << "KMFRuleEdit::slotEditIPopt()" << endl;
	slotEditRule();
	m_iped->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_iped );
}

void KMFRuleEdit::slotEditMacOpt() {
	kdDebug() << "KMFRuleEdit::slotEditIPopt()" << endl;
	slotEditRule();
	m_maced->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_maced );
}

void KMFRuleEdit::slotEditProtOpt() {
	kdDebug() << "KMFRuleEdit::slotEditProtOpt()" << endl;
	slotEditRule();
	m_proted->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_proted );
}

void KMFRuleEdit::slotEditIntOpt() {
	kdDebug() << "KMFRuleEdit::slotAddIntOpt()" << endl;
	slotEditRule();
	m_inted->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_inted );
}
void KMFRuleEdit::slotEditStateOpt() {
	kdDebug() << "KMFRuleEdit::slotAddIntOpt()" << endl;
	slotEditRule();
	m_stateed->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_stateed );
}

void KMFRuleEdit::slotEditLimitOpt() {
	kdDebug() << "KMFRuleEdit::slotAddIntOpt()" << endl;
	slotEditRule();
	m_limited->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_limited );
}

void KMFRuleEdit::slotEditTosOpt() {
	kdDebug() << "KMFRuleEdit::slotEditTosOpt()" << endl;
	slotEditRule();
	m_tosed->setType( "CHECKTOS" );
	m_tosed->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_tosed );
}

void KMFRuleEdit::slotEditCustomOpt() {
	kdDebug() << "KMFRuleEdit::slotEditTosOpt()" << endl;
	slotEditRule();
	KMessageBox::information ( this , i18n( "<qt><p>You are about to define custom options for this rule.<br>"
																										"There will be <b>no sanity checks</b> for your input, so please make shure "
																										"that your options are working and the syntax is correct.</p></qt>" ),
																										i18n("Information"),"custom_option_warning" );
	m_custom_opt->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_custom_opt );
}

void KMFRuleEdit::slotEditRuleInfo() {
	slotEditRule();
	m_rule_info->loadRule( m_rule );
	m_widgetStack->raiseWidget( m_rule_info );
}

void KMFRuleEdit::slotEditTargetOption() {
	kdDebug() << "void KMFRuleEdit::slotEditTargetOption()\n Target: " << cb_target->currentText() << endl;
	QString target = cb_target->currentText();
	if ( target == "LOG" ) {
		m_tglog ->loadRule( m_rule );
		m_widgetStack->raiseWidget( m_tglog );
	} else if ( target == "SNAT" ) {
		m_tgnat ->loadRule( m_rule );
		m_tgnat ->setMode( true );
		m_widgetStack->raiseWidget( m_tgnat );
	} else if ( target == "DNAT" ) {
		m_tgnat ->loadRule( m_rule );
		m_tgnat ->setMode( false );
		m_widgetStack->raiseWidget( m_tgnat );
	} else if ( target == "TOS" ) {
		m_tosed->loadRule( m_rule );
		m_tosed->setType( "SETTOS" );
		m_widgetStack->raiseWidget( m_tosed );
	} else if ( target == "REJECT" ) {
		m_tosed->loadRule( m_rule );
		m_tosed->setType( "REJECTTYPE" );
		m_widgetStack->raiseWidget( m_tosed );
	} else if ( target == "MARK" ) {
		m_tgmark->loadRule( m_rule );
		m_widgetStack->raiseWidget( m_tgmark );
	} else {
		KMessageBox::sorry( this, i18n( "There are no options available\n"
		                                "for the selected target." ), i18n( "Rule Editor" ) );
	}
}

void KMFRuleEdit::slotInstallFirewall() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotInstallFW();
}
void KMFRuleEdit::slotUninstallFirewall() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotUninstallFW();
}
void KMFRuleEdit::slotRunFirewall() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotRunFW();
}

void KMFRuleEdit::slotResetFirewall() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotStopFW();
}

void KMFRuleEdit::slotShowOutputViewer() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->raise();
}

void KMFRuleEdit::slotShowIPTConfig() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotShowAll();
}
void KMFRuleEdit::slotShowFilter() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotShowFilter();
}
void KMFRuleEdit::slotShowNat() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotShowNat();
}
void KMFRuleEdit::slotShowMangle() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotShowMangle();
}
void KMFRuleEdit::slotShowScript() {
	m_widgetStack->raiseWidget( m_output_viewer );
	m_output_viewer->slotShowScript();
}

void KMFRuleEdit::slotEditChain() {
	kdDebug() << "void KMFRuleEdit::slotEditChain()" << endl;
	m_editchain -> loadChain( m_chain );
	m_widgetStack->raiseWidget( m_editchain );
}

// Slots For Rule Edit Changes
void KMFRuleEdit::slotFragChanged() {
	kdDebug() << "KMFRuleEdit::slotFragChanged(bool frag)" << endl;
	bool frag = cb_frag->isChecked();
	bool frag_inv = cb_frag_inv->isChecked();
	if ( frag ) {
		QPtrList<QString>* vals = new QPtrList<QString>;
		if ( frag_inv ) {
			QString * neg = new QString( "!" );
			vals->append( neg );
		} else {
			QString* neg = new QString( "" );
			vals->append( neg );
		}
		QString* cmd = new QString( "frag" );
		m_rule->addRuleOption( *cmd, *vals );
	} else {
		QString* cmd = new QString( "frag" );
		m_rule->delRuleOption( *cmd );
	}
	kmfdoc->changed();
	slotUpdatePreview( true );
}

void KMFRuleEdit::slotLogRuleChanged() {
	if ( cb_log_rule->isChecked() )
		m_rule->setLogging( true );
	else
		m_rule->setLogging( false );
	kmfdoc->changed();
	slotUpdatePreview( true );
}

void KMFRuleEdit::slotEnableRuleChanged() {
	if ( cb_disable_rule->isChecked() ) {
		m_rule->setEnabled( false );
	} else {
		m_rule->setEnabled( true );
	}
	kmfdoc->changed();
	slotUpdatePreview( true );
}

void KMFRuleEdit::slotTargetChanged( const QString& tg ) {
	kdDebug() << "KMFRuleEdit::slotTargetChanged(const QString&)" << endl;
	if ( !tg.isEmpty() ) {
		if ( tg == m_rule->chain() ->name() ) {
			KMessageBox::sorry( this, i18n( "<qt><p>Sorry, you <b>can not</b> set the target of this rule to be it's own chain. "
			                                "Constructing enles loops is not allowed.</qt>" ) );
			return ;
		}

		m_rule->setTarget( tg );
		kmfdoc->changed();
		slotNewChainSelected( m_curr_chain_name );
		//		slotUpdatePreview( true );
	}
}


void KMFRuleEdit::slotAddRuleOption( QString* name, QPtrList<QString>* values ) {
	kdDebug() << "KMFRuleEdit::slotAddRuleOption(QString* name, QPtrList<QString>* values)" << endl;
	m_rule->addRuleOption( *name, *values );
	kmfdoc->changed();
	slotUpdatePreview( true );
}
void KMFRuleEdit::slotDelRuleOption( QString* name ) {
	kdDebug() << "KMFRuleEdit::slotDelRuleOption(QString* name)" << endl;
	m_rule->delRuleOption( *name );
	kmfdoc->changed();
	slotUpdatePreview( true );
}

void KMFRuleEdit::slotAddTargetOption( QString* name, QPtrList<QString>* values ) {
	kdDebug() << "KMFRuleEdit::slotAddTargetOption(QString* name, QPtrList<QString>* values)" << endl;
	m_rule->addTargetOption( *name, *values );

	slotUpdatePreview( true );
}
void KMFRuleEdit::slotDelTargetOption( QString* name ) {
	kdDebug() << "KMFRuleEdit::slotDelTargetOption(QString* name)" << endl;
	m_rule->delTargetOption( *name );
	kmfdoc->changed();
	slotUpdatePreview( true );
}

void KMFRuleEdit::slotRuleRBM( QListViewItem* item, const QPoint & point, int ) {
	kdDebug() << "void KMFRuleEdit::RBM(QListViewItem* item, const QPoint & point, int)" << endl;
	if ( item ) {
		if ( KMFRuleLVItem * tmp_item = dynamic_cast<KMFRuleLVItem *>( item ) ) {
			m_rule = 0;
			m_rule = tmp_item->rule();
			m_chain = m_rule->chain();
			m_curr_rule_item = currRuleParentItem( tmp_item );
			if ( updateCurrRule() && m_curr_rule_item ) {
				createRBM( *m_rule );
				m_contextMenu->popup( point );
			}
		} else if (  KMFChainLVItem * tmp_item = dynamic_cast<KMFChainLVItem *>( item )  ){
			m_curr_rule_item = 0;
			m_chain = tmp_item->chain();
			slotNewChainSelected( m_curr_chain_name );
			createRBM( *m_chain );
			m_contextMenu->popup( point );
		}
	}
}


void KMFRuleEdit::editChain( IPTChain* chain ) {
	kdDebug() << "void KMFRuleEdit::slotEditChain(IPTChain* chain)" << endl;
	if ( chain == 0 ) {
		m_err->setErrType( "FATAL" );
		const QString& msg = i18n( "KMFRuleEdit:::slotEditChain(IPTChain* chain)\n"
		                           "IPTChain* chain == 0. This is a bug." );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
		return ;
	}
	QString chain_name = chain->name();
	QString table_name = chain->table() ->name();
	if ( table_name == "filter" ) {
		rb_filter->setChecked( true );

	} else if ( table_name == "nat" ) {
		rb_nat->setChecked( true );

	} else if ( table_name == "mangle" ) {
		rb_mangle->setChecked( true );

	} else {
		m_err->setErrType( "FATAL" );
		const QString& msg = i18n( "KMFRuleEdit:::slotEditChain(IPTChain* chain)\n"
		                           "Table: %1 unknown by the iptable/netfilter" ).arg( table_name );
		m_err->setErrMsg( msg );
		m_err_handler->showError( m_err );
		return ;
	}

	slotNewTableSelected();
	uint i = 0;
	for ( QStringList::ConstIterator it = m_curr_chains->begin();
	      it != m_curr_chains->end(); ++it, ++i) {
		if ( *it == chain_name ) {
			cb_chain->setCurrentItem( i );
			m_curr_chain_name = chain_name;
			slotNewChainSelected( m_curr_chain_name );
			return ;
		}
	}

	m_err->setErrType( "NORMAL" );
	const QString& msg = i18n( "KMFRuleEdit:::slotEditChain(IPTChain* chain)\n"
	                           "Table: %1 unknown by the iptable/netfilter." ).arg( table_name );
	m_err->setErrMsg( msg );
	m_err_handler->showError( m_err );
	return ;
}

void KMFRuleEdit::createRBM( const IPTChain& chain ) {
	kdDebug() << "void createRBM( IPTChain* ){" << endl;
	m_contextMenu->clear();
	QString name = chain.name();
	QString lab_str = "Chain Name: " + name;

	m_contextMenu->insertTitle( lab_str );
	m_contextMenu->insertItem( icon_new, i18n( "Add Rule..." ), this, SLOT( slotAddRule() ) );
	m_contextMenu->insertSeparator();
	m_contextMenu->insertItem( icon_edit, i18n( "Edit Chain" ), this, SLOT( slotEditChain() ) );
	m_contextMenu->insertItem( icon_del, i18n( "Delete Chain" ), this, SLOT( slotDelChain() ) );
}

void KMFRuleEdit::createRBM( const IPTRule& rule ) {
	kdDebug() << "void createRBM( IPTRule* ){" << endl;
	m_contextMenu->clear();
	QString name = rule.name();
	QString lab_str = "Rule Name: " + name;
	m_contextMenu->insertTitle( lab_str );


	KPopupMenu *sub_edit = new KPopupMenu( m_contextMenu );
	sub_edit->insertTitle( i18n( "Edit Rule Option" ) );
	sub_edit->insertItem( icon_edit, i18n( "Edit IP Option" ), this, SLOT( slotEditIPopt() ) );
	sub_edit->insertItem( icon_edit, i18n( "Edit MAC Option" ), this, SLOT( slotEditMacOpt() ) );
	sub_edit->insertItem( icon_edit, i18n( "Edit Protocol Option" ), this, SLOT( slotEditProtOpt() ) );
	sub_edit->insertSeparator();
	sub_edit->insertItem( icon_edit, i18n( "Edit Interface Option" ), this, SLOT( slotEditIntOpt() ) );
	sub_edit->insertItem( icon_edit, i18n( "Edit Stateful Option" ), this, SLOT( slotEditStateOpt() ) );
	sub_edit->insertItem( icon_edit, i18n( "Edit Limit Option" ), this, SLOT( slotEditLimitOpt() ) );
	sub_edit->insertItem( icon_edit, i18n( "Edit Tos Option" ), this, SLOT( slotEditTosOpt() ) );
	sub_edit->insertItem( icon_edit, i18n( "Edit Custom Option" ), this, SLOT( slotEditCustomOpt() ) );
	QString target = rule.target();
	if ( target == "LOG" || target == "SNAT" || target == "DNAT" || target == "TOS" ||
		target == "REJECT" || target ==  "REJECTTYPE" || target == "MARK" ) {
		sub_edit->insertSeparator();
		sub_edit->insertItem( icon_edit, i18n( "Edit Target Option" ), this, SLOT( slotEditTargetOption() ) );
	}

	m_contextMenu->insertSeparator();
	m_contextMenu->insertItem( i18n( "Edit Rule Option" ), sub_edit );
	m_contextMenu->insertItem( icon_new, i18n( "Add Rule..." ), this, SLOT( slotAddRule() ) );
	m_contextMenu->insertItem( icon_del, i18n( "Delete Rule" ), this, SLOT( slotDelRule() ) );
	m_contextMenu->insertSeparator();
	m_contextMenu->insertItem( icon_rename, i18n( "Rename Rule" ), this, SLOT( slotRenameRule() ) );
	m_contextMenu->insertItem( icon_edit, i18n( "Rule Documentation" ), this, SLOT( slotEditRuleInfo() ) );
	m_contextMenu->insertItem( icon_up, i18n( "Move Up" ), this, SLOT( slotMoveRuleUp() ) );
	m_contextMenu->insertItem( icon_down, i18n( "Move Down" ), this, SLOT( slotMoveRuleDown() ) );
	m_contextMenu->insertSeparator();
	m_contextMenu->insertItem( icon_edit, i18n( "Edit Chain" ), this, SLOT( slotEditChain() ) );
	m_contextMenu->insertItem( icon_del, i18n( "Delete Chain" ), this, SLOT( slotDelChain() ) );
	m_contextMenu->insertSeparator();

	KPopupMenu *sub_copy = new KPopupMenu( m_contextMenu );
	connect( sub_copy, SIGNAL( activated( int ) ), this, SLOT( slotCopyRule( int ) ) );
	sub_copy->insertTitle( i18n( "Copy to Chain" ) );
	QPtrList<IPTChain> chains = kmfdoc->table( *m_table ) ->chains();
	for ( uint i = 0; i < chains.count(); i++ ) {
		QString tmp_name = chains.at( i ) ->name();
		sub_copy->insertItem( tmp_name, i );
	}
	m_contextMenu->insertItem( icon_copy, i18n( "Copy Rule" ), sub_copy );

	KPopupMenu *sub_move = new KPopupMenu( m_contextMenu );
	connect( sub_move, SIGNAL( activated( int ) ), this, SLOT( slotMoveRule( int ) ) );
	sub_move->insertTitle( i18n( "Move to Chain" ) );
	QPtrList<IPTChain> chains2 = kmfdoc->table( *m_table ) ->chains();
	for ( uint i = 0; i < chains2.count(); i++ ) {
		QString tmp_name = chains2.at( i ) ->name();
		sub_move->insertItem( tmp_name, i );
	}
	m_contextMenu->insertItem( icon_move, i18n( "Move Rule" ), sub_move );
}

void KMFRuleEdit::slotMoveRule( int index ) {
	kdDebug() << "void KMFRuleEdit::slotCopyRule( int )" << endl;
	kdDebug() << "Copy to Chain Nr: " << index << endl;
	IPTChain *chain_target = kmfdoc->table( *m_table ) ->chains().at( index );
	m_err = m_rule->chain() ->table() ->moveRuleToChain( m_rule, chain_target );
	m_err_handler->showError( m_err );
	kmfdoc->changed();
	slotReloadDocument();
	//	slotNewChainSelected( m_curr_chain_name );
}

void KMFRuleEdit::slotCopyRule( int index ) {
	kdDebug() << "void KMFRuleEdit::slotCopyRule( int )" << endl;
	kdDebug() << "Copy to Chain Nr: " << index << endl;
	IPTChain *chain_target = kmfdoc->table( *m_table ) ->chains().at( index );
	m_err = m_rule->chain() ->table() ->copyRuleToChain( m_rule, chain_target );
	m_err_handler->showError( m_err );
	kmfdoc->changed();
	slotReloadDocument();
	//	slotNewChainSelected( m_curr_chain_name );
}

void KMFRuleEdit::slotRenameRule() {
	KMFRuleLVItem * tmp_item = currRuleParentItem();
	if ( tmp_item == 0 )
		return ;
	else
		tmp_item->startRename( 2 );
}

//void KMFRuleEdit::dropEvent( QDropEvent* e ) {
//	kdDebug() << "void KMFRuleEdit::dropEvent( QDropEvent* e)" << endl;
//}



KMFRuleLVItem* KMFRuleEdit::currRuleParentItem( KMFRuleLVItem* item ) {
	if ( item ) {
		if ( KMFRuleLVItem * tmp_item = dynamic_cast<KMFRuleLVItem *>( lv_rules->selectedItem() ) ) {
			if ( item->isTopItem() ) {
				return item;
			} else {
				bool found = false;
				KMFRuleLVItem *tmp_item;
				while ( !found ) {
					tmp_item = dynamic_cast<KMFRuleLVItem *>( item->parent() );
					if ( tmp_item ) {
						if ( tmp_item->isTopItem() ) {
							//							kdDebug() << "Foud top Item" << endl;
							found = true;
							return tmp_item;
						}
						item = tmp_item;
					} else {
						//						kdDebug() << "No KMFRuleLVItem Item!!!" << endl;
						found = true;
						return 0;
					}
				}
			}
		} else {
			return 0;
		}
	} else {
		return 0;
	}
	return 0;
}



KMFRuleLVItem* KMFRuleEdit::currRuleParentItem() {
	KMFRuleLVItem * item = ( KMFRuleLVItem* ) lv_rules->selectedItem();
	return currRuleParentItem( item );
}


void KMFRuleEdit::slotRenameRule( QListViewItem* item, int, const QString& name ) {
	if ( item ) {
		KMFRuleLVItem * tmp_item = ( KMFRuleLVItem* ) item;
		IPTRule* tmp_rule = tmp_item->rule();
		QString new_name = name;
		if ( !name.isEmpty() ) {
			QPtrList<IPTRule>& rules = tmp_rule->chain() ->chainRuleset();
			IPTRule *rule;
			for ( rule = rules.first(); rule; rule = rules.next() ) {
				if ( rule ) {
					if ( rule->name() == name ) {
						KMessageBox::sorry( this, i18n( "<qt><p>Sorry, there is already a rule named: <b>%1</b> in the chain.<br>"
						                                "Please make shure that the new rule name is unique in its chain.</qt>" ).arg( name ) );
						slotNewChainSelected( m_curr_chain_name );
						return ;
					}
				}
			}
			m_err = tmp_rule->setName( new_name );
			if ( m_err_handler->showError( m_err ) ) {
				kmfdoc->changed();
			}
			slotNewChainSelected( m_curr_chain_name );

		} else {
			m_err -> setErrType( "NORMAL" );
			const QString& msg = i18n( "No new name given. A rule <b>must</b> have a name" );
			m_err -> setErrMsg( msg );
			m_err_handler->showError( m_err );
			slotNewChainSelected( m_curr_chain_name );
		}
	}
}



/*
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool KMFRuleEdit::event( QEvent* ev ) {
	bool ret = QWidget::event( ev );
	if ( ev->type() == QEvent::ApplicationFontChange ) {}
	return ret;
}
void KMFRuleEdit::slotHelp() {
	kdDebug() << "void KMFRuleEdit::slotHelp()" << endl;
	kapp->invokeHelp( "rules" );
}
void KMFRuleEdit::loadIcons() {
	kdDebug() << "void KMFRuleEdit::loadIcons()" << endl;
	KIconLoader *loader = KGlobal:: iconLoader();
	QString icon_name;

	icon_name = "up";
	icon_up = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "down";
	icon_down = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editdelete";
	icon_del = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filenew";
	icon_new = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "edit";
	icon_edit = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "view_detailed";
	icon_rule = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "text";
	icon_rename = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "view_tree";
	icon_chain = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "view_detailed";
	icon_rule = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "reject";
	icon_reject = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "target";
	icon_target = loader->loadIcon( icon_name, KIcon::User );

	icon_name = "stop";
	icon_drop = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "button_ok";
	icon_accept = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filesaveas";
	icon_log = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "undo";
	icon_return = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editclear";
	icon_cmd = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "filter";
	icon_filter = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "pipe";
	icon_queue = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "editcopy";
	icon_copy = loader->loadIcon( icon_name, KIcon::Small );

	icon_name = "forward";
	icon_move = loader->loadIcon( icon_name, KIcon::Small );


}
#include "kmfruleedit.moc"
