//
// C++ Implementation: kmfpfcompiler
//
// Description:
//
//
// Author: Christian Hubinger <e9806056@student.tuwien.ac.at>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfpfcompiler.h"

// QT includes
#include <qptrlist.h>
#include <qstringlist.h>
#include <qmultilineedit.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/kmfgenericdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfnetzone.h"
#include "../../core/kmfnethost.h"
#include "../../core/kmfprotocol.h"
#include "../../core/kmferror.cpp"

#include "../../kmfwidgets/kmflistview.h"

KMFPFCompiler::KMFPFCompiler( QObject* parent, const char* name ) : KMFPlugin( parent, name )  {
	m_osName = i18n("openbsd");
	m_osGUIName = i18n("OpenBSD");
	m_backendName = i18n("pf");
	m_backendGUIName = i18n("PF");

	
	
	if ( genericDoc() ) {
		/*KAction *m_actionExportPF = */new KAction( i18n( "Export as &PF (OpenBSD) Script" ),  "fileexport",
									0, this, SLOT( slotExportPF() ), actionCollection(), "compile_pf" );

		/*KAction *m_actionShowPFScript = */new KAction( i18n( "Show &PF (OpenBSD) Script" ),  "fileexport",
									0, this, SLOT( slotShowPFScript() ), actionCollection(), "show_pf_sript" );

		setXMLFile( "kmfpfcompiler.rc" );
		kdDebug() << "KMFPFCompiler: Finished initialisation." << endl;
	}
}


KMFPFCompiler::~KMFPFCompiler() {}

const QString& KMFPFCompiler::osName(){
	return m_osName;
}
const QString& KMFPFCompiler::osGUIName(){
	return m_osGUIName;
}
const QString& KMFPFCompiler::backendName(){
	return m_backendName;
}
const QString& KMFPFCompiler::backendGUIName(){
	return m_backendGUIName;
}


void KMFPFCompiler::compile() {
	kdDebug() << "void KMFPFCompiler::compile()" << endl;
	kdDebug() << "Doc XML:\n"  << m_doc->getXMLSniplet() << endl;
}

void KMFPFCompiler::slotExportPF() {
	kdDebug() << "KMFPFCompiler::slotExportIPT()" << endl;
	QString s = compile( genericDoc() );
	kdDebug() << "Generated scrip: "  << s  << endl;
}

void KMFPFCompiler::slotShowPFScript() {
	kdDebug() << "void KMFPFCompiler::slotShowPFScript()" << endl;
	QMultiLineEdit* ed = new QMultiLineEdit( 0, "edit" );
	ed->setText( compile( genericDoc() ) );
	setOutputWidget( ed );
	showOutput();
}

const QString& KMFPFCompiler::compile( KMFGenericDoc* ) {
	kdDebug() << "const QString& KMFPFCompiler::compile( KMFGenericDoc* doc )" << endl;
	return *(new QString("NO VALUE") );
}

// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFPFCompilerFactory::s_instance = 0L;
// KAboutData* KMFPFCompilerFactory::s_about = 0L;

KMFPFCompilerFactory::KMFPFCompilerFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFPFCompilerFactory" );
}

QObject* KMFPFCompilerFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFPFCompiler( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFPFCompilerFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFPFCompilerFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfcompiler_pf() {
		return new KMFPFCompilerFactory;
	}
}

#include "kmfpfcompiler.moc"
