//
// C++ Interface: kmfpfcompiler
//
// Description:
//
//
// Author: Christian Hubinger <e9806056@student.tuwien.ac.at>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFPFCOMPILER_H
#define KMFPFCOMPILER_H

#include "../../interfaces/kmfcompilerinterface.h"

/**
@author Christian Hubinger
*/

// QT includes
#include <qstring.h>
#include <qobject.h>

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>

// Project includes
class KMFGenericDoc;
class KMFIPTDoc;
class KMFNetZone;
class IPTChain;

#include "../../interfaces/kmfplugin.h"
#include "../../interfaces/kmfcompilerinterface.h"


class KMFPFCompiler :  public KMFPlugin, public virtual KMFCompilerInterface {
	Q_OBJECT
public:
	KMFPFCompiler( QObject* parent, const char* name );
	~KMFPFCompiler();
	void compile();
	const QString& compile( KMFGenericDoc* );
	const QString& osName();
	const QString& osGUIName();
	const QString& backendName();
	const QString& backendGUIName();

private:
	KMFGenericDoc *m_doc;
	QString m_osName;
	QString m_osGUIName;
	QString m_backendName;
	QString m_backendGUIName;
private slots:
	void slotExportPF();
	void slotShowPFScript();
};




class KInstance;

class KMFPFCompilerFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFPFCompilerFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFPFCompilerFactory() {
/* 		delete s_instance; */
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};



#endif
