/***************************************************************************
                                 dock.cpp
                             -------------------                                         
    begin                : Mon Aug 9 1999                                           
    copyright            : (C) 1999 by Markus Gustavsson                         
    email                : mighty@fragzone.se                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "dock.h"

Dock::Dock(QWidget *mainwin, QWidget *parent, const char *name) : QWidget(parent,name)
{
	KWin::setSystemTrayWindowFor(winId(), mainwin->winId());
	setBackgroundColor(QColor(0, 0, 0));
	resize(24, 24);
    show();

	buf = (int *) calloc(24, sizeof(int));

	pos = 0;
	old = 0;
}

Dock::~Dock()
{
	free(buf);
}

void Dock::setDirection(bool set)
{
	direction = set;
	repaint();
}

void Dock::setGrid(bool set)
{
	grid = set;
	repaint();
}

void Dock::setText(bool set)
{
	text = set;
	repaint();
}

void Dock::setSoft(bool set)
{
	soft = set;
	repaint();
}

void Dock::setFill(int set)
{
	fill = set;
	repaint();
}

void Dock::setCol(int set)
{
	col = set;
	repaint();
}

void Dock::setSpd(int set)
{
	spd = set;
	repaint();
}

void Dock::setScale(int set)
{
	scale = set;
	repaint();
}

void Dock::setOn(bool set)
{
	on = set;
	repaint();
}

void Dock::setClr(void)
{
	for(i = 0; i < 24; i++) *(buf + i) = 0;
	repaint();
}

void Dock::mousePressEvent(QMouseEvent *Event)
{
	emit mouseClick(Event);
}

void Dock::paintEvent(QPaintEvent *Event)
{
	Event = (QPaintEvent *) 0;
	QPainter p(this);

	if(grid) {
		p.setPen((on) ? QColor(120, 120, 120) : QColor(60, 60, 60));
		p.drawLine(0, 4, 23, 4);
		p.drawLine(0, 9, 23, 9);
		p.drawLine(0, 14, 23, 14);
		p.drawLine(0, 19, 23, 19);
	}

	if(fill == 2) {
		for(i = 0; i < 24; i++) {
			tmp = (pos + i + 1 < 24) ? *(buf + pos + i + 1) : *(buf + pos + i - 23);
			for(i2 = 0; i2 <= tmp; i2++) {
				tmp2 = (tmp) ? (255 / tmp) * i2 : 0;
				tmp3 = (tmp) ? ((255 / tmp) * i2) / 2 : 0;

				if(col == 0) p.setPen((on) ? QColor(0, 0, tmp2) : QColor(0, 0, tmp3));
				else if(col == 1) p.setPen((on) ? QColor(0, tmp2, 0) : QColor(0, tmp3, 0));
				else if(col == 2) p.setPen((on) ? QColor(tmp2, tmp2 / 2, 0) : QColor(tmp3, tmp3 / 2, 0));
				else if(col == 3) p.setPen((on) ? QColor(tmp2, 0, tmp2) : QColor(tmp3, 0, tmp3));
				else if(col == 4) p.setPen((on) ? QColor(tmp2, 0, 0) : QColor(tmp3, 0, 0));
				else if(col == 5) p.setPen((on) ? QColor(0, tmp2, tmp2) : QColor(0, tmp3, tmp3));
				else p.setPen((on) ? QColor(tmp2, tmp2, 0) : QColor(tmp3, tmp3, 0));

				p.drawPoint(i, 23 - i2);
			}
		}		
	} else {
		if(col == 0) p.setPen((on) ? QColor(0, 0, 255) : QColor(0, 0, 128));
		else if(col == 1) p.setPen((on) ? QColor(0, 255, 0) : QColor(0, 128, 0));
		else if(col == 2) p.setPen((on) ? QColor(255, 128, 0) : QColor(128, 64, 0));
		else if(col == 3) p.setPen((on) ? QColor(255, 0, 255) : QColor(128, 0, 128));
		else if(col == 4) p.setPen((on) ? QColor(255, 0, 0) : QColor(128, 0, 0));
		else if(col == 5) p.setPen((on) ? QColor(0, 255, 255) : QColor(0, 128, 128));
		else p.setPen((on) ? QColor(255, 255, 0) : QColor(128, 128, 0));

		if(fill == 1) for(i = 0; i < 24; i++) p.drawLine(i, 23 - ((pos + i + 1 < 24) ? *(buf + pos + i + 1) : *(buf + pos + i - 23)), i, 23);
		else for(i = 0; i < 24; i++) p.drawPoint(i, 23 - ((pos + i + 1 < 24) ? *(buf + pos + i + 1) : *(buf + pos + i - 23)));
	}

	if(text) {
		p.setFont(QFont("Helvetica", 8));
		p.setPen((on) ? QColor(255, 255, 255) : QColor(125, 125, 125));
		p.drawText(rect(), AlignLeft | AlignTop, (direction) ? "OUT" : "IN");
	}
}

void Dock::step(float val)
{
	if(++pos > 23) pos = 0;

	if((val *= (float) 8)) {
		val = val / ((float) scale / (float) 23);
		val = val / ((float) spd / (float) 1000);
		if(val > (float) 23) tmp = 23;
		else if(val < (float) 0) tmp = 0;
		else tmp = (int) val;
	} else tmp = 0;

	if(soft) {
		if(tmp == (old + 1)) old += 1;
		if(tmp == (old + 2)) old += 2;
		if(tmp >= (old + 3)) old += 3;
		if(tmp == (old - 1)) old -= 1;
		if(tmp == (old - 2)) old -= 2;
		if(tmp <= (old - 3)) old -= 3;
		*(buf + pos) = old;
	} else *(buf + pos) = tmp;

	repaint();
}



