/***************************************************************************
                          knutdock.h  -  description
                             -------------------
    begin                : t z? 23 2003
    copyright            : (C) 2003 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTDOCK_H
#define KNUTDOCK_H

#include "knutupsdata.h"
#include "knutvardata.h"
#include "knutconst.h"


#include <ksystemtray.h>
#include <kpopupmenu.h>

//#include <qpixmap.h>
//#include <qstring.h>

#include <qobject.h>

 namespace knc {
 enum eTypeOfIcons { pictureKI, generalKI};

 const int DefaultToolTipFlags = 0x398;
 
 enum toolTipItems {
   TTMFR = 0x8, // 8,    // FRM
   TTModel = 0x10, // 16,    // Model
   TTSerial = 0x20, // 32,    // Serial
   TTFirm = 0x40, //64,    // Firmware Revision
   TTRun = 0x80,// 128,    // Runtime
   TTCharge = 0x100, // 256,    // Charge
   TTLoad = 0x200 // 512    // Load
   };

 }

 enum upsConnection {
   connected,
   ok,
   error
   };
 
class QString;
class QPixmap;
 
/**
 * Tato trida zajistuje vytvoreni icony v docku.
 *
 * @author Daniel Prynych
 * @short Dock-ova ikona
 * @version 0.2
  */
class KNutDock : public KSystemTray  {
  Q_OBJECT
  public: 

/**
 * Konstruktor - vytvori iconu v docku.
 *
 * @param  tActiveUpsInfo odkaz na structuru upsInfo
 * @param  tSettingData  odkaz na strukturu typu SettingDataDef
 * @param  tUpsRecord odkaz na instanci tridy tActiveUpsInfo
 * @since  0.1
 */
    KNutDock(struct upsInfo* tActiveUpsInfo, SettingDataDef* tSettingData, KNutUpsData* tUpsRecords);

/**
 * Destruktor.
 *
 * @since  0.1.2
 **/
    ~KNutDock();


/**
 * Vytvori menu (seznam) UPS.
 *
 * @since  0.1
 **/
  void changeUps(void);


/**
 * Zmeni styl/typ icon
 *
 * @since  0.1
 **/
  void changeKIcon (void);

/**
 * Zmeni pozadi icony v kickeru
 *
 * @since  0.2
 **/
  void changeKIBColor(void);


/**
 * Zmeni prvky v tooltip-u
 *
 * @since  0.1
 **/
  void changeToolTip(void);

/**
 * Provede nove zpracovani dat a jejich vykresleni.
 * Zrusi vykresleni chyby
 *
 * @since  0.2.1
 **/
  void repaintDock ( const int netError, const bool always = false);


/**
 * Nastavi vse pro vykresleni zakladni ikony.
 * Tato ikona je kreslena dokud neni navazano spojeni
 *
 * @since  0.2
 **/
  void initImage(void);
  

/**
 * Nastavi v Menu oznaceni pro aktivni ups
 *
 * @since  0.1
 **/
  void setNewUPS(void);
   
  signals:
/**
 * Tento signal je vyslan pokud bylo vybrano v menu ukonceni aplikace.
 *
 * @since  0.1
 **/
  void endApplication(void);

/**
 * Tento signal je vyslan pokud bylo vybrano v menu minimalizace aplikace.
 *
 * @since  0.1
 **/
  void minimize(void);

/**
 * Tento signal je vyslan pokud bylo vybrano v menu polozka preferences.
 *
 * @since  0.1
 **/
  void preferences(void);

  
        
/**
 * Tento signal je vyslan pokud byla vybrana activace hlavniho okna (Main Window).
 *
 * @since  0.1
 **/
  void activeMainWindow(void);


/**
 * Tento signal je vyslan pokud bylo vybrano zobrazeni promennych;
 *
 * @since  0.1
 **/
  void printUPSVars(void);

/**
 * Tento signal je vyslan pokud bylo vybrano provedeni okamziteho prikazu;
 *
 * @since  0.1
 **/
  void instComms(void);

/**
 * Tento signal je vyslan pokud bylo vybrana zmena RW promennych;
 *
 * @since  0.1
 **/
  void RWVars(void);

/**
 * Tento signal je vyslan pokud bylo vybrana zmena RW promennych;
 * This signal is emited when refresh connection was selected
 *
 * @since  0.1
 **/
  void makeRefreshConnection(void);
 

/**
 * Tento signal je vyslan pokud je vybrana nova UPS;
 *
 * @since  0.1
 **/
  void UPSChanged(QString name);


  protected slots:
    virtual void mousePressEvent(QMouseEvent *e);
    void showMyAbout();
    void slotExitApplication (void);
    void slotMinimize (void);
    void slotPreferences (void);
    void slotPrintUPSVars(void);
    void slotInstComms(void);
    void slotRWVars(void);
    void slotUpsName(int i);
    void slotRefreshConnection(void);

  
  protected:

/**
 * @internal
 * Nastavi ToolTip.
 *
 * @since  0.1
 **/
    void toolTip (int runtime, int status, int batteryCharge, int upsLoad );


/**
 * @internal
 * Vytvori a hlavni menu panelu.
 *
 * @since  0.1
 **/
    void createMainMenu(void);

/**
 * @internal
 * Vytvori a podmenu pro seznam UPS-ek.
 *
 * @since  0.1
 **/
    void createUpsMenu(void);

/**
 * @internal
 * Vykresli cisl0.
 * @param number je hodnota cisla.
 * @param x je leva souradnice cisla
 * @param y je horni souradnice cisla
 * @param p je ukazatel na painter
 *
 * @since  0.1
 **/
    void paintNumbers (int numbers, int x, int x, QPainter* p ); //x,y levy horni roh cisla 1

/**
 * @internal
 * Vykresli cislici.
 * @param number je hodnota cislice.
 * @param x je leva souradnice cislice
 * @param y je horni souradnice cislice
 * @param p je ukazatel na painter
 *
 * @since  0.1
 **/
    void paintNumber (int x, int y, int number, QPainter *p);

/**
 * @internal
 * Vykresli znak.
 * @param x je leva souradnice cislice
 * @param y je horni souradnice cislice
 * @param p je ukazatel na painter
 * @param char je vykreslovany znak.
 *
 * @since  0.1
 **/
    void paintChar (int x, int y, char LCDChar, QPainter *p);


/**
 * @internal
 * Vykresli pomlcku.
 * @param x je leva souradnice pomlcky
 * @param y je horni souradnice pomlcky
 * @param p je ukazatel na painter
 *
 * @since  0.1
 **/
    void paintDash (int x, int y, QPainter *p);

    
/**
 * @internal
 * Vykresli vrstvu runtime.
 * Vrstva je samostatna plocha
 *
 * @since  0.1
 **/
    void paintRuntime (int runtime, int status);

/**
 * @internal
 * Vykresli vrstvu pro UPS Load.
 * Vrstva je samostatna plocha
 *
 * @since  0.1
 **/
    void paintLoad (int load );

/**
 * @internal
 * Vykresli vrstvu pro Battery Charge.
 * Vrstva je samostatna plocha
 *
 * @since  0.1
 **/
    void paintCharge (int charge );

/**
 * @internal
 * Vykresli vrstvu pro UPS Status.
 * Vrstva je samostatna plocha
 *
 * @since  0.1
 **/
    void paintStatus (int status );

/**
 * @internal
 * Vykresli sablonu pro vrstvu baterie.
 * Ma vyznam jen pro typ picture.
 *
 * @since  0.1
 **/
    void paintBattery (void);

/**
 * @internal
 * Vykresli sablonu pro vrstvu load.
 * Ma vyznam jen pro typ picture.
 *
 * @since  0.1
 **/
    void paintUps (void);

    void paintEvent (QPaintEvent *);

/**
 * @internal
 * Vykresli do hlavni vrstvy zeleny bod.
 * Ma vyznam jen pro typ picture.
 *
 * @since  0.1
 **/
    void paintErrorPoint ( void );

/**
 * @internal
 * Vykresli do hlavni vrstvy cerveny bod.
 * Ma vyznam jen pro typ picture.
 *
 * @since  0.1
 **/
    void paintOKPoint ( void );



    KNutUpsData* upsRecords;
    SettingDataDef* settingData;  // v teto strukture jsou ulozeny promene ktere nastavuji konfiguraci
    struct upsInfo* activeUpsInfo; // hodnoty pro vybrane ups
  
    QPixmap mainPix;
    QPixmap errorPix;
  
    KPopupMenu* menu;
    KPopupMenu* upsServerMenu;

    QPixmap *statusLayer;
    QPixmap *runtimeLayer;
    QPixmap *loadLayer;
    QPixmap *chargeLayer;
    QPixmap *mainLayer;
    QPixmap *batteryLayer;
    QPixmap *upsLayer;

    int runtimeValue;
    int upsLoadValue;
    int batteryChargeValue;
    int statusValue;
    int statusBatValue;
    int statusWarningValue;


    upsConnection dataOk; // urcuje jeden ze trich typu zobrazeni
    upsConnection dataOkOld;

    int typeOfIcon;
    QColor myBGColor;
    unsigned int toolTipFlags;

    // zde je posledni hodnota chyby s kterou byla volana proc. repaintDock
    int oldNetError;

};

#endif
