/***************************************************************************
                          knutprintupsvar.cpp  -  description
                             -------------------
    begin                : St cec 3 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutprintupsvar.h"
#include "knutvardata.h"

#include <kmessagebox.h>
#include <kglobal.h>
#include <kiconloader.h>
  
#include <qgroupbox.h>
#include <qscrollview.h>
#include <qtooltip.h>
#include <qlabel.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qstring.h>



//#include <iostream>


// od verze 0.6.0  nebudeme vytvaret vlastni spojeni

KNutPrintUpsVar::KNutPrintUpsVar(KNutNet* const upsNet, const bool useDescription, QWidget* parent,  const char* name, const bool modal )
: KDialogBase(Plain, i18n("Variables"),User1|Cancel,Ok, parent, name, modal, true), myUpsNet(upsNet){

  upsVar myStructVar;
  upsIComm myStructIComm;
  dataVar pointerVar;
  dataList.clear();

  setButtonText(User1,i18n("Reload Vars"));
  setName( "knutprintupsvar" );
  setCaption( i18n("UPS variables") );

  int error;  
  if ((error = myUpsNet->getUpsValues(true))) {
    KNutVarData::showError (error);
    upsConnectOk = false;
    }
  else {
    upsConnectOk = true;
    countVars=myUpsNet->readNumberVars(KNutNet::AllVars);
    countRWVars=myUpsNet->readNumberVars(KNutNet::RWVars);
    countIComms=myUpsNet->readNumberComms();

    KIconLoader *loader = KGlobal::iconLoader();
    dirPixmap=loader->loadIcon ("folder_open",KIcon::Small,16);

    page = plainPage();
    QHBoxLayout* upsVarsMainLayout = new QHBoxLayout(page);

    table = new KListView(page);
    table->setRootIsDecorated(true);

    table->setAllColumnsShowFocus( TRUE );
    table->setFullWidth ( true );

    table->addColumn( i18n("Name") );
    table->addColumn( i18n("Value") );
    if (useDescription)
      table->addColumn( i18n("Description") );
    table->setSorting (-1);  
    
    upsVarsMainLayout->addWidget(table);


    KListViewItem* myListItem;
    if (countIComms) {
      
      ICommList = new KListViewItem( table, i18n("Instant Commands"));
      ICommList->setOpen(true);

      for (int i=0; i<countIComms; i++) {
        myUpsNet->readIComm(i+1,myStructIComm);

        myListItem = addListItem( ICommList,myStructIComm.upsCommName,"");
        if ((!myStructVar.upsDescription.isEmpty()) && useDescription)
          myListItem->setText(2,myStructIComm.upsDescription);
       }
     }
    
    if (countRWVars) {
      RWVarsList = new KListViewItem( table, i18n("Read/Write Variables"));
      RWVarsList->setOpen(true);
      for (int i=0; i<countVars; i++) {
        myUpsNet->readVars(i+1,myStructVar);

        if (!myStructVar.upsVarType) {
          pointerVar.myName=myStructVar.upsVarName;
          pointerVar.myValue = addListItem( RWVarsList,myStructVar.upsVarName,myStructVar.upsValue);

       if ((!myStructVar.upsDescription.isEmpty()) && useDescription)
          pointerVar.myValue->setText(2,myStructVar.upsDescription);

          dataList.push_back(pointerVar);
         }
       }
     }


    ROVarsList = new KListViewItem( table, i18n("Read Only Variables"));
    ROVarsList->setOpen(true);

    for (int i=0; i<countVars; i++) {
      myUpsNet->readVars(i+1,myStructVar);
      if (myStructVar.upsVarType) {

        pointerVar.myName=myStructVar.upsVarName;
        pointerVar.myValue = addListItem( ROVarsList,myStructVar.upsVarName,myStructVar.upsValue);

       if ((!myStructVar.upsDescription.isEmpty()) && useDescription)
          pointerVar.myValue->setText(2,myStructVar.upsDescription);

       dataList.push_back(pointerVar);
       }
     }  

    connect (this,SIGNAL(user1Clicked()),this,SLOT(slotReloadVars()));
    } // end else
  }
     


KNutPrintUpsVar::~KNutPrintUpsVar(){
  dataList.clear();
  delete page;
  }


void KNutPrintUpsVar::slotReloadVars (void) {
  upsVar myStructVar;
  
  if (myUpsNet->getUpsValues(true) !=0)
    KNutVarData::showError (myUpsNet->getError());
  else {

    QValueVector<dataVar>::const_iterator it;
    for (it = dataList.begin(); it != dataList.end(); it++) {
      myUpsNet->readVars((*it).myName,myStructVar);
      (*it).myValue->setText (1,myStructVar.upsValue);
      }
    }
  }

  KListViewItem* KNutPrintUpsVar::addListItem (KListViewItem* table, QString varName, QString value) {
  KListViewItem* myListItem;
  KListViewItem* helpListItem;
  QString left;
  int n;

  myListItem = table;
  do {
    n = varName.find(".");
    if (n > 0) {
      left = varName.left(n);
      varName = varName.mid(n+1);
      if (!(helpListItem = existListItem( myListItem,left))) {
        myListItem = new KListViewItem( myListItem, left);
        myListItem->setOpen(true);
        }
      else myListItem = helpListItem;
      if (!myListItem->pixmap(0)) myListItem->setPixmap(0,dirPixmap);
      }
    else { // end part
      helpListItem = new KListViewItem( myListItem, varName, value);
      helpListItem->setOpen(true);
      return helpListItem;
      }
    } while (n > -1);
  return 0; // for compiler only  
  }


    KListViewItem* KNutPrintUpsVar::existListItem (KListViewItem* listItem, QString name) {
    KListViewItem*  myItem;
  
    if (!(myItem = (KListViewItem *)listItem->firstChild())) return 0l;
    while (myItem) {
      if (myItem->text(0) == name) return myItem;
      myItem = (KListViewItem *)myItem->nextSibling(); 
      }
    return 0l;
    }

bool KNutPrintUpsVar::upsOk (void) { return upsConnectOk; }


#include "knutprintupsvar.moc"

