/* @(#) .del-dbmem.h 1.7 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: db
\***************************************************************/

#ifndef _KOALAMUD_LIB_VNODE_H
#define _KOALAMUD_LIB_VNODE_H "@(#) nitehawk@winghove.1ststep.net|BitKeeper/deleted/.del-dbmem.h|20000308020841|19679 @(#)"

/* vnodes are the in memory database tracking structures.  This in memory
 * tracking tree is important to maintain a reasonable speed during searches
 */

/* We need the file system types, even from the user side */
#include "lib/fstypes.h"
#include "lib/fs.h"
#include "lib/dir.h"
#include "lib/dnode.h"

/* Prototype structs */
struct TAG_KVNODE;
struct TAG_KVDIRENT;
struct TAG_MOUNTSTAT;

/* This structure is used to keep track of the file descriptor and various
 * other state information needed in memory */
typedef struct TAG_MOUNTSTAT
{
	struct TAG_MOUNTSTAT *next;	// Pointer to next mount structure
	char *mountpath;	// Path that we are mounted on
	char *devicepath;	// Path to the device or file on disk
	int dbfd;			// File descriptor for the database file
	struct TAG_KVNODE *root;	// Pointer to root vnode
	superblock *sb;		// Pointer to first superblock on disk
	void *dnodetbl;		// Pointer to the dnode table of superblock 0
	void *blktbl;		// Pointer to the block table of superblock 0
} mountstat, *pmountstat;

/* This structure is loaded for each active file and every file as it becomes
 * active. */
typedef struct TAG_KVNODE
{
	struct TAG_KVNODE *parent;	// Pointer to parent directory
	struct TAG_KVDIRENT *dir;	// Pointer to the head of the vdirent list
	kdbfs_dnode_t	dnodenum;	// Dnode number
	kdbfs_blockid_t	superblock;	// Block number that this dnode is listed under
	pmountstat	mount;			// Pointer to the mountstat structure
	dnode	*dn;				// Pointer to dnode on disk
} kvnode, *pkvnode;

/* This structure is used for each of the in memory directory entries.  Keep
 * it small */
typedef struct TAG_KVDIRENT
{
	char *name;					// Entry name
	struct TAG_KVDIRENT *next;	// Pointer to next directory entry
	pkvnode	vn;					// Pointer to the vnode
	kdbfs_dnode_t	dnodenum;	// Dnode for this directory entry
	pmountstat	mount;			// Pointer to the mountstat structure
	u_int8_t	type;			// File type (see lib/dir.h
} kvdirent, *pkvdirent;

#endif
