/* @(#) signal.c 1.11 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: SIGNAL
\***************************************************************/

#define _KOALAMUD_SIGNAL_C "@(#) nitehawk@localhost.1ststep.net|lib/koala/signal.c|20000823031748|14884 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "sig.h"
#include "memory.h"
#include "llist.h"

/* Shutdown system */
void sigshutdown(int sig)
{
	kstate.running = DSTATE_SHUTDOWN;
}

/* Reboot System */
void sigreboot(int sig)
{
	kstate.running = DSTATE_REBOOT;
}

/* Print out process information */
void siginfo(int sig)
{
	listnodeptr desclist;
	pdescriptor desc;
	int numhub, numzone, numcli, numlisten, numplayer;

	/* Initialize counters */
	numhub = numzone = numcli = numlisten = numplayer = 0;

	/* get list pointer */
	desclist = getdescriptorlist();

	/* loop through the list and log status */
	for (;desclist; desclist = listnextnode(desclist))
	{
		desc = desclist->data.desc;

		switch(desc->type)
		{
			case DESCRIPTOR_HUBSRV:
				numhub++;
				logmsg(LOGINFO,
						"Hub: nodeid=%d, Socket=%d, %d bytes buffered,"
						" Current MessageID=%d",
						desc->nodeid, desc->socket,
						abs(desc->buffer.intail - desc->buffer.inhead),
						desc->data.hubsrv->curmsg.messageid);
				break;

			case DESCRIPTOR_CLIENTSRV:
				numcli++;
				logmsg(LOGINFO,
						"Client: nodeid=%d, Socket=%d, %d bytes buffered,"
						" Current MessageID=%d",
						desc->nodeid, desc->socket,
						abs(desc->buffer.intail - desc->buffer.inhead),
						desc->data.clientsrv->curmsg.messageid);
				break;
			case DESCRIPTOR_ZONESRV:
				numzone++;
				logmsg(LOGINFO,
						"Zone: nodeid=%d, Socket=%d, %d bytes buffered,"
						" Current MessageID=%d",
						desc->nodeid, desc->socket,
						abs(desc->buffer.intail - desc->buffer.inhead),
						desc->data.zonesrv->curmsg.messageid);
				break;
			case DESCRIPTOR_PLAYER:
				numplayer++;
				logmsg(LOGINFO,
						"Player: Name='%s', Socket=%d, %d bytes buffered",
						desc->data.character->name, desc->socket,
						abs(desc->buffer.intail - desc->buffer.inhead));
				break;
			case DESCRIPTOR_LISTEN:
				numlisten++;
				logmsg(LOGINFO,
						"Listen: Socket=%d",
						desc->socket);
				break;
			default:
		}
	}

	/* Print out a summary line */
	logmsg(LOGINFO, "uplinks: %d hub, %d client, %d zone",
			numhub, numcli, numzone);
	logmsg(LOGINFO, "%d Listen, %d players", numlisten, numplayer);
}

/* Use signal syscall to setup signal handling */
koalaerror initsighandlers(void)
{
	signal(SIGINT, sigshutdown);
	signal(SIGTERM, sigshutdown);
	signal(SIGHUP, sigreboot);
	signal(SIGPIPE, SIG_IGN);
	signal(SIGUSR1, siginfo);

	return KESUCCESS;
}
