/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef SHAREDFOLDER_PAGE_H
#define SHAREDFOLDER_PAGE_H

#include "page.h"

class SharedFolderPage : public Page
{
  public:
    SharedFolderPage();
    ~SharedFolderPage();

    virtual QString name() const;
    virtual QString title() const;
    virtual QString description() const;
    virtual QString iconName() const;
    virtual ListingModel* model();

    virtual Form::Description* formDescription();
    virtual Form::PagePolicy* formPolicy();
    virtual Form::Record* formRecord();

  private:
    ListingModel *mModel;
    Form::Description *mDescription;
    Form::PagePolicy *mPolicy;
    Form::Record *mRecord;
};

#endif
