/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "auth.h"

#include "user_description.h"
#include "user_listingmodel.h"
#include "user_policy.h"
#include "user_record.h"

#include "user_page.h"

UserPage::UserPage()
  : mModel( 0 ), mDescription( 0 ),
    mPolicy( 0 ), mRecord( 0 )
{
}

UserPage::~UserPage()
{
  delete mModel;
  mModel = 0;

  delete mDescription;
  mDescription = 0;

  delete mPolicy;
  mPolicy = 0;

  delete mRecord;
  mRecord = 0;
}

QString UserPage::name() const
{
  return "user";
}

QString UserPage::title() const
{
  return QObject::tr( "Users" );
}

QString UserPage::description() const
{
  return QObject::tr( "Manage email users" );
}

QString UserPage::iconName() const
{
  return "user";
}

bool UserPage::hasListingMode() const
{
  if ( Auth::self()->group() == Auth::Users )
    return false;
  else
    return true;
}

ListingModel* UserPage::model()
{
  if ( !mModel )
    mModel = new UserListingModel;

  return mModel;
}

Form::Description* UserPage::formDescription()
{
  if ( !mDescription )
    mDescription = new Form::UserDescription;

  return mDescription;
}

Form::PagePolicy* UserPage::formPolicy()
{
  if ( !mPolicy )
    mPolicy = new Form::UserPolicy;

  return mPolicy;
}

Form::Record* UserPage::formRecord()
{
  if ( !mRecord )
    mRecord = new Form::UserRecord;

  return mRecord;
}
