/***************************************************************************
                          komba2view.h  -  description
                             -------------------
    begin                : Wed Jan 31 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOMBA2VIEW_H
#define KOMBA2VIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qlistview.h>
#include <qsplitter.h>
#include <kpopupmenu.h>
#include "mytip.h"

class InfoTab;
class Komba2Doc;
class MyShareItem;
/** The Komba2View class provides the view widget for the Komba2App instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As Komba2View is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the Komba2App class to manipulate and display
 * the document structure provided by the Komba2Doc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class Komba2View:public QSplitter
{
Q_OBJECT public:
    /** Constructor for the main view */
  Komba2View (QWidget * parent = 0, const char *name = 0);
    /** Destructor for the main view */
   ~Komba2View ();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a Komba2App instance as a parent
     * widget to get to the window document pointer by calling the Komba2App::getDocument() method.
     *
     * @see Komba2App#getDocument
     */
  Komba2Doc *getDocument () const;
    /** contains the implementation for printing functionality */
  void print (QPrinter * pPrinter);
  // akt. Itemrect there mouse is over
  QRect tip (const QPoint &, QString & s);
  void itemDataChanged (QListViewItem * item);
  QListView *nettree ()
  {
    return mynettree;
  };
  void newMountedShare (MyShareItem * share);
  void delMountedShare (MyShareItem * share);
  void setInfoTab (QListViewItem * item);
  void setSplitterPos (QValueList < int >i);
  QValueList < int >getSplitterPos ();
protected:
  void setMenu (QListViewItem * item);
private:

  MyTip * tooltip;		// can show ToolTips on spezified Rect
  KPopupMenu *popupmenu;
  InfoTab *myinfotab;
  QListView *mynettree;
  protected slots:		// Protected slots
    /* an Item will be expanded */
  void setTheCurrentItem (QListViewItem * item);
  void slotExpanded (QListViewItem * item);
  // Popupmenu
  void slotRightButtonMenu (QListViewItem * item, const QPoint & p, int l);
  /** the currend Item has changed */
  void slotItemRemoved (QListViewItem * item);
  void selItemChanged (QListViewItem * item);
  void slotSearchTree ();
  void slotSendMessage ();
  void slotMountedClicked ();
  public slots:
//      void slotMount();
  void slotMountTo ();
//      void slotUnmount();
  void slotListMountedRightButtonMenu (QListViewItem * item, const QPoint & p,
				       int l);
//      void slotListNetNamesRightButtonMenu( QListViewItem * item, const QPoint &p, int l);
  void slotCurrentHasChanged (QListViewItem * item);
  void slotNoActiveProcess ();
};

#endif // KOMBA2VIEW_H
