/***************************************************************************
                          mount.h  -  description
                             -------------------
    begin                : Son Apr 16 19:02:07 CEST 2000
    copyright            : (C) 2000 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MOUNT_H
#define MOUNT_H

#include <qobject.h>
#include <qstring.h>
#include <kprocess.h>

/***************************************************************************
 *                                                                         *
 *   class calls smbmount																								   *
 *   on exit it will set the signal isExited (connect this!)               *
 *                                                                         *
 ***************************************************************************/
class MyShareItem;

class Mount:public QObject
{
Q_OBJECT private:
  KProcess * proc;		// The Process
  QString out;
  QString err;
  QString mountp;
  MyShareItem *shareitem;
  int ver;
  bool exploreaftermount;
public:
    Mount (QObject * parent, MyShareItem * sitem, int smbmountversion,
	   const QString & mountpoint, bool expl = true, bool automount =
	   false);
  virtual ~Mount ();
  /** Startet den mount-Process */
  void start ();
  MyShareItem *getShareItem ()
  {
    return shareitem;
  };
  QString & getMountPath ()
  {
    return mountp;
  };
  bool explore ()
  {
    return exploreaftermount;
  };
  int getVersion ()
  {
    return ver;
  };
protected:			// Protected methods
  /** call the options-method by ver */
  void setOptions (int ver);
  /** options for smbmount-version 2.06 will be set */
  void setOptionsV206 ();
  /** options for smbmount-version 2.05a will be set */
  void setOptionsV205 ();
  public slots:			// Public slots
  /** read output of smbmount */
  void mountStdout (KProcess * p, char *buffer, int n);
  /** read errormessages of smbmount */
  void mountStderr (KProcess * p, char *buffer, int n);
  /** is called when smbmount is exited */
  void onProcExit (KProcess * killedproc);
signals:
  void isExited (Mount * m, QString & err, MyShareItem * item);
  /** all Output will be send  */
  void Output (const QString & text);
  void Command (const QString & text);

};

#endif
