/***************************************************************************
                          ping.cpp  -  description
                             -------------------
    begin                : Thu Feb 1 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kdebug.h>
#include "ping.h"

Ping::Ping (QString ip, Prog p, QWidget * parent, const char *name):
DebugOutput (parent, name)
{
  proc = 0;
  out = "";
  err = "";
  the_ip = ip;
  prog = p;
  setCaption (name + QString (" : ") + ip);
}

Ping::~Ping ()
{
  if (proc)
    {
      kdWarning (7199) << "Ping : Process not exited ..." << endl;
      proc->kill ();
      delete proc;
    }
}

/** Startet den mount-Process */
void
Ping::start ()
{
  proc = new KProcess ();
  if (prog == ProgPing)
    (*proc) << "ping" << "-c 3" << the_ip;
  else
    (*proc) << "/usr/sbin/traceroute" << the_ip;

  connect (proc, SIGNAL (processExited (KProcess *)), this,
	   SLOT (onProcExit (KProcess *)));
  connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (slotStdout (KProcess *, char *, int)));
  connect (proc, SIGNAL (receivedStderr (KProcess *, char *, int)), this,
	   SLOT (slotStdout (KProcess *, char *, int)));
  proc->start (KProcess::NotifyOnExit, KProcess::All);
  show ();
}

/* Ausgaben werden Abgefangen */
void
Ping::slotStdout (KProcess *, char *buffer, int n)
{
  QString b (QString::fromLocal8Bit (buffer, n));
  err += b;
  addOutputText (b);
}

/** Wird aufgerufen wenn der Process sich beendet */
void
Ping::onProcExit (KProcess * killedproc)
{
  if (killedproc == proc)
    {
      delete proc;
      proc = 0;
    }
  else
    kdWarning (7199) << "Ping : Mmmhhh... not my process" << endl;
}
