/***************************************************************************
                          plugin_katespeaker.cpp  -  description
                             -------------------
    begin                :  07 17 2001
    copyright            : (C) 2001 by Matteo Merli
    email                : merlim@libero.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "plugin_katespeaker.h"

#include <kaction.h>
#include <kinstance.h>
#include <kmessagebox.h>
#include <klocale.h>
//#include <cassert>
//#include <kdebug.h>
#include <kprocess.h>
#include <kprocio.h>
#include <qstring.h>

extern "C"
{
	void* init_libkatespeakerplugin() {
		return new KatePluginFactory;
	}
}

KatePluginFactory::KatePluginFactory()
{
	s_instance = new KInstance( "kate" );
}

KatePluginFactory::~KatePluginFactory()
{
	delete s_instance;
}

QObject* KatePluginFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
	return new PluginKateSpeaker( parent, name );
}

KInstance* KatePluginFactory::s_instance = 0L;

PluginKateSpeaker::PluginKateSpeaker( QObject* parent, const char* name )
	: Kate::Plugin ( parent, name )
{
}

PluginKateSpeaker::~PluginKateSpeaker()
{
}

Kate::PluginView *PluginKateSpeaker::createView (Kate::MainWindow *win)
{
	Kate::PluginView *view = new Kate::PluginView (this, win);

	(void)  new KAction ( i18n("&Speak selection..."), ALT + Key_Plus, this,
					SLOT( slotSpeak() ), view->actionCollection(), "speak_selection" );

	view->setXML( "plugins/katespeaker/ui.rc" );

	return view;
}

void PluginKateSpeaker::slotSpeak()
{
	Kate::View *kv=myApp->getViewManager()->getActiveView();
	if (!kv) return;

	QString query = kv->markedText();

	if ((query == QString::null) || (query == 0) ) {
		QString title = i18n( "No selected Text" );
		QString text = i18n( "There was no text selected to read, please "
						"correct it and try again" );
		KMessageBox::sorry( 0L, text, title );
		return;
	}

	KProcIO process;
        process << "festival"
		<< "--tts";

	process.start(KProcess::DontCare);
	process.writeStdin(query);
}

#include "plugin_katespeaker.moc"

