
#ifndef KORE_H
#define KORE_H

#if defined( WIN32 )
#define KORE_WIN32
#include <windows.h>
#ifdef KORE_EXPORTS
#define KORE_API __declspec(dllexport)
#else // !KORE_EXPORTS
#define KORE_API __declspec(dllimport)
#endif // KORE_EXPORTS
#elif defined( __BEOS__ )
#define KORE_BEOS
#include <image.h>
#ifdef KORE_EXPORTS
#define KORE_API __declspec(dllexport)
#else // !KORE_EXPORTS
#define KORE_API __declspec(dllimport)
#endif // KORE_EXPORTS
#define HMODULE image_id
#elif defined( __ATHEOS__ )
#define KORE_ATHEOS
#define KORE_API
#define HMODULE int
#else
#define KORE_UNIX
#define KORE_LINUX
#define KORE_FREEBSD
#define KORE_API
#define HMODULE const void*
#endif

/**
 * Kore callbacks. Pre-alfa version (not tested).
 */
#define KORE_CALLBACK( name, param_list ) \
public: \
    typedef void (* name##CallbackType) param_list; \
    void name##Call param_list \
    { \
        if( name param_list ) \
        { \
            int n = _##name##Callbacks.size(); \
            for( int i=0; i < n; i++ ) \
                _##name##Callbacks[i] param_list; \
        } \
    } \
    void name##Connect(name##CallbackType cb) \
    { \
        _##name##Callbacks.push_back( cb ); \
    } \
    void name##Disconnect(name##CallbackType cb) \
    { \
        _##name##Callbacks.erase( &cb ); \
    } \
protected: \
    virtual bool name param_list \
    { \
        return true; \
    } \
private: \
    vector< name##CallbackType > _##name##Callbacks;

#define KORE_CALL( name, param_list ) name##Call param_list
#define KORE_CONNECT( name, cb ) name##Connect( cb )
#define KORE_DISCONNECT( name, cb ) name##Diconnect( cb )

/**
 * This namespace holds the Kernel and kore API(s).
 */
namespace kore
{
};

using namespace std;

#endif // KORE_H
