
#include <qapp.h>
#include <qbutton.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qheader.h>
#include <qstring.h>
#include <qdialog.h>

#include <kore/version.h>
#include <kore/kernel.h>
#include <kore/modulemanager.h>
#include <kore/servicemanager.h>

#include "modulebrowser_impl.h"
#include "moduleview.h"
#include "moduleviewfactory.h"

#define MB_MAJOR 0
#define MB_MINOR 0
#define MB_REVISION 1
#define MB_VERSION "0.0.1"
#define MB_API_MAJOR 0
#define MB_API_MINOR 0
#define MB_API_REVISION 2
#define MB_API_VERSION "0.0.2"
#define MB_NAME "Module Browser"
#define MB_TYPE MODULEBROWSER_TYPE
#define MB_DESCRIPTION "Diplays the list of Kore Modules registered to the Kore ModuleManager."
#define MB_SERVICE MODULEBROWSER_SERVICE
#define MB_SERVICE_DESCRIPTION "'" MODULEBROWSER_SERVICE "' service"

using namespace kore;

ModuleBrowserImpl::ModuleListItem::ModuleListItem( QListView* parent, Module* mod): QListViewItem( parent )
{
    _module = mod;
    const Module::Info* nfo = mod->info();
    QString addr;
    addr.sprintf("0x%08x", mod);
    int cols = parent->columns();
    for(int i=0; i<cols; i++)
    {
        QString colName = parent->columnText( i );
        QString txt;
        if( colName == "ID" )
            txt = addr;
        else if ( colName == "Name" )
            txt = nfo->name();
        else if ( colName == "Type" )
            txt = nfo->type();
        else if ( colName == "Version" )
            txt = (const char*) (*nfo->version());
        else if ( colName == "API Version" )
            txt = (const char*) (*nfo->APIVersion());
        else if ( colName == "Description" )
            txt = nfo->description();
        setText(i, txt);
    }
}

/*
 *  Constructs a ModuleBrowserImpl which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */
ModuleBrowserImpl::ModuleBrowserImpl( QWidget* parent,  const char* name, WFlags fl )
    : ModuleBrowserWidget( parent, name, fl )
{
    _mbVersion = new Version(MB_MAJOR,MB_MINOR,MB_REVISION,MB_VERSION);
    _mbAPIVersion = new Version(MB_API_MAJOR,MB_API_MINOR,MB_API_REVISION,MB_API_VERSION);
    _mbInfo = new Info(this, MB_NAME, MB_TYPE, MB_DESCRIPTION, _mbVersion, _mbAPIVersion);
    setInfo(_mbInfo);
    _mbService = new Service(this, MB_SERVICE, MB_SERVICE_DESCRIPTION);
    addService(_mbService);

    slotRefreshModuleList();
}

/*
 *  Destroys the object and frees any allocated resources
 */
ModuleBrowserImpl::~ModuleBrowserImpl()
{
    // no need to delete child widgets, Qt does it all for us
    delete _mbInfo;
    delete _mbVersion;
    delete _mbAPIVersion;
    delete _mbService;
}

/*
 * protected slot
 */
void ModuleBrowserImpl::slotClose()
{
    QApplication::exit(0);
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotRefreshColumns(int id)
{
    QButton* btn = showColumns->find(id);
    QString columnName(btn->text());
    columnName.remove(0,1);
    if( btn->isOn() )
    {
        moduleListView->addColumn( columnName );
        slotRefreshModuleList();
    }
    else
    {
        int column;
        for(column = 0; column < moduleListView->columns() ; column++)
            if( moduleListView->columnText( column ) == columnName )
                break;
        moduleListView->removeColumn(column);
    }
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotRefreshModuleList()
{
    ModuleManager* mm = dynamic_cast<ModuleManager*> (Kernel::instance()->serviceManager()->registeredProvider("Kore/Kernel/Module Manager"));
    if( !mm ) // ouch! No ModuleManager found...
        return;
    Module** modules = mm->registeredModules();
    moduleListView->clear();
    for(int i=0; modules[i]; i++)
        (void) new ModuleListItem( moduleListView, modules[i] );
    delete[] modules;
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotSelectionChanged()
{
    bool noSelection = true;
    for( QListViewItem* item = moduleListView->firstChild(); item; item = item->nextSibling() )
        if( moduleListView->isSelected( item ) )
        {
            noSelection = false;
            break;
        }
    if( noSelection )
    {
        unregisterButton->setEnabled(false);
        propertiesButton->setEnabled(false);
    }
    else
    {
        unregisterButton->setEnabled(true);
        propertiesButton->setEnabled(true);
    }
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotShowModuleProperties()
{
    ServiceManager* sm = Kernel::instance()->serviceManager();
    ModuleViewFactory* mvf = dynamic_cast<ModuleViewFactory*> (sm->registeredProvider("Kore/UI/Module View/Factory"));
//    ModuleView* mv;
    if( !mvf ) // eek, we cannot create ModuleViews !
        return;
    for( QListViewItem* item = moduleListView->firstChild(); item; item = item->nextSibling() )
        if( moduleListView->isSelected( item ) )
//        {
            mvf->reuseView( dynamic_cast<ModuleListItem*>(item)->module(), this )->show();
//            mv->show();
//        }
    slotRefreshModuleList();
}
/*
 * protected slot
 */
void ModuleBrowserImpl::slotUnregisterModules()
{
    ModuleManager* mm = dynamic_cast<ModuleManager*> (Kernel::instance()->serviceManager()->registeredProvider("Kore/Kernel/Module Manager"));
    if( !mm ) // ouch! No ModuleManager found...
        return;
    for( QListViewItem* item = moduleListView->firstChild(); item; item = item->nextSibling() )
        if( moduleListView->isSelected( item ) )
            mm->unregisterModule( dynamic_cast<ModuleListItem*>(item)->module() );
    slotRefreshModuleList();
}
