//
// C++ Interface: kpgdatatablesettings
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGDATATABLESETTINGS_H
#define KPGDATATABLESETTINGS_H

#include "../kpgsettings.h"

class KPGDataTableSettingsPage;

/**
Data table settings

	@author Lumir Vanek <lvanek@users.sourceforge.net>
*/
class KPGDataTableSettings : public KPGSettings
{
public:
    KPGDataTableSettings( QObject * pParent = 0, const char * pszName = 0 );
    ~KPGDataTableSettings();
    
	bool confirmDelRow() const { return m_bConfirmDelRow; }
    int lobBufferSize() const { return m_iLobBufferSize; }
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual QString dialogPageName() const;
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual QString dialogPageHeader() const;
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual QString dialogPageIcon() const;
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual QWidget * dialogPage( QFrame * pParent );

protected:

    /**
     * Derived from @ref KPGSettings
     */
    virtual void write( KConfig * ) const;
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual void read( const KConfig * );
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual void setFromPage();
    
    /**
     * Derived from @ref KPGSettings
     */
    virtual void updatePage() const;

    // the settings itself
    bool m_bConfirmDelRow;
    int m_iLobBufferSize;
    
    /**
     * the corresponding configuration dialog page
     * It is created on demand by @ref dialogPage.
     */
    KPGDataTableSettingsPage * m_pDialogPage;
};

#endif
