//
// C++ Implementation: kpgcreateschemawidget1
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreateschemawidget1.h"

// include files for KDE
#include <klineedit.h>
#include <klistbox.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../kpgutil.h"

KPGCreateSchemaWidget1::KPGCreateSchemaWidget1(QWidget *parent, const char *name, KPGUsersFolder *pUsersFolder)
 : KPGCreateSchemaWidget1Base(parent, name)
{
	m_pLineEditSchemaName->setFocus();
	
	//--- traverse list of users
	QListViewItem * pItem = pUsersFolder->firstChild();
	while(pItem)
	{
		if((static_cast <KPGTreeItem *> (pItem))->type() == KPGTreeItem::nodeUser)
			m_pComboBoxOwner->insertItem(*pItem->pixmap(0), pItem->text(0));
				
		pItem = pItem->nextSibling();
	}
}


KPGCreateSchemaWidget1::~KPGCreateSchemaWidget1()
{
}

void KPGCreateSchemaWidget1::slotLineEditSchemaNameChanged(const QString &strSchemaName)
{
	emit sigEnableNextButton(strSchemaName.length() > 0);
}

const QString KPGCreateSchemaWidget1::getSQL() const
{
	QString strSQL("CREATE SCHEMA ");
	
	strSQL.append(KPGUtil::quotedName(m_pLineEditSchemaName->text()));
	
	if(m_pComboBoxOwner->currentItem() > 0)
		strSQL.append(" AUTHORIZATION " + KPGUtil::quotedName(m_pComboBoxOwner->currentText()));
	
  if(m_pComboBoxTablespace->currentItem() > 0)
    strSQL.append(" TABLESPACE " + KPGUtil::quotedName(m_pComboBoxTablespace->currentText()));
    
	return strSQL;
}

#include "kpgcreateschemawidget1.moc"
