// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "AudioBuildImage.h"
#include "AudioFileInfo.h"

#include "AudioBuildImage.moc"

#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/stat.h>
#include <sys/ioctl.h>

#include <qtimer.h>
#include <qobject.h>

#include <kapp.h>
#include <klocale.h>

AudioBuildImage::AudioBuildImage(AudioFileInfo *afil,const char *sfn):
  AudioFileConvert(afil,buildImageHFork,0) {
  sourceFile=sfn;
  autoQuit=true;
}

void AudioBuildImage::disableAutoQuit(void) {
  autoQuit=false;
}

int AudioBuildImage::buildImageHFork(ProcessInterface *afi,const char *fn) {
  int rv;
  AudioBuildImage *abi;
  abi=(AudioBuildImage *) (afi);
  rv=abi->buildImageFork(fn,0,abi->sourceFile);
  if (rv) {
    fprintf(stdout,"#OK#\n");
  } else {
    fprintf(stdout,"#ERROR#\n");
  }
  return(0);
}

int AudioBuildImage::buildImage(const char *fn) {

  strcpy(imageFilename,fn);
  setForkArgument(imageFilename);
  prepareProcess();

  reportAction(i18n("Converting audio track to CD-R format\n"));
  ImagizeFlag=0;

  startProcess();
  return(1);
}

int AudioBuildImage::processCleanup(int retval) {
  if (retval==-1) {
    retval=0;
    remove(imageFilename);
  }
  closeProcess();
  return(retval);
}


int AudioBuildImage::processExited(void) {
  return(ImagizeFlag);
}

bool AudioBuildImage::processStdoutLine(char *linebuffer) {
  if (strncmp("#OK#",linebuffer,4)==0) {
    ImagizeFlag=1;
    return(true);
  }
  if (strncmp("#ERROR#",linebuffer,7)==0) {
    ImagizeFlag=0;
    return(true);
  }

  if (strncmp("#PROGRESS#",linebuffer,10)==0) {
    char *xptr,*yptr;
    unsigned long int cur,max;
    xptr=linebuffer+10;
    while (*xptr==' ') ++xptr;
    if (*xptr==0) return(true);
    cur=strtoul(xptr,&yptr,10);
    xptr=yptr;
    while (*xptr==' ') ++xptr;
    if (*xptr==0) return(true);
    max=strtoul(xptr,&yptr,10);
    reportProgress(cur*1000*4,max*1000*4);
  }
  if (strncmp("#DONE#",linebuffer,6)==0) {
    char out[10];
    emit(conversionDone(this,-1));
    if (autoQuit) {
      sprintf(out,"#KILL#\n");
      writeStdin(out,7);
    }
  }
  return(true);
}

