// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#ifndef AUDIOFILECONVERT_INCLUDED
#define AUDIOFILECONVERT_INCLUDED

#include "ProcessInterface.h"
#include <qobject.h>

class AudioFileInfo;
class AudioFileOp;

#include <unistd.h>

class AudioFileConvert : public ProcessInterface {
  Q_OBJECT
 public:
  AudioFileConvert(AudioFileInfo *afil);
  AudioFileConvert(AudioFileInfo *afil,int (*fx)(ProcessInterface *afi,const char *fn),const char *fnx);
  ~AudioFileConvert(void);
  
 protected:

  long int                     startAudio;
  int      buildImageFork(const char *fn,int playmode,const char *sfn=0);
  static int buildImageHFork(ProcessInterface *afi,const char *fn);

  AudioFileOp *fileOp;
  int ImagizeFlag;
  AudioFileInfo *audioInfo;
};
#endif

