// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef AUDIOFILEFORMAT_INCLUDED
#define AUDIOFILEFORMAT_INCLUDED

#include "ProcessInterface.h"
#include "FormatPlugin.h"

#include <qobject.h>
#include <qlist.h>
#include <qstring.h>

class AudioFileInfo;
class AudioFileOp;

class FormatPlugin {
  public:
    KLibrary *plugin_handle;
    AudioIdentify * (*identifyFactory)(void);   
    AudioIdentify *identify;
    QString plugin_path;
};


class AudioFileFormat : public QObject {
  Q_OBJECT

    public:
  AudioFileFormat(AudioFileInfo *afil);
  ~AudioFileFormat(void);
  
  int  identifyFile(const char *filename);
  int  setupCDTrack(long frames);

  static void loadPlugins();
  static void unloadPlugins();  

    protected:
    
  AudioFileInfo *audioInfo;
  AudioFileOp   *fileOp;

    private:
    
  static QList<FormatPlugin> *plugins;
  static int registerPlugin(FormatPluginHeader *hd,QString plugin_path=QString::null);
  
};

#endif

