// KreateCD - CD recording software for the K desktop environment
//
// 1999-2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef AUDIORIPPER_INCLUDED
#define AUDIORIPPER_INCLUDED

#include "ProcessInterface.h"

/**
    @short AudioRipper - base class for audio ripping from CD
    @author Alexander Feigl <Alexander.Feigl@gmx.de>
    @version $id$

*/

class AudioRipper : public ProcessInterface {
  Q_OBJECT

    public:
  virtual bool ripAudio(int track,const char *filename);

 protected:
  virtual bool doRip(int track,const char *filename);
  virtual int  processExited(void);
  virtual int  processCleanup(int rval); 
  
  void startTrack(long int size);
  void setPosition(long int pos);

  int ripflag;
  long int trackSize;
 private:
  char imageFilename[1024];

};

#endif
