// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Niels Reedijk <nielx@kde.nl>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <kdialogbase.h>

class ConfigPathWidget;
class ConfigSCSIWidget;
class ISOOptions;
class ConfigProjectType;
class ConfigBurnerWidget;

class ConfigDialog : public KDialogBase {
  Q_OBJECT
    public:
  ConfigDialog( QWidget *parent , const char *name );
  ~ConfigDialog();
  void hide();
 signals:
  void closed();
  protected slots:
    void slotOk();
  void slotApply();
  void slotCancel();
 private:
  ConfigPathWidget *theConfigPathWidget;
  ConfigSCSIWidget *theConfigSCSIWidget;
  ISOOptions *theISOOptions;
  ConfigProjectType *theConfigProjectType;
  ConfigBurnerWidget *theConfigBurnerWidget;
};

#endif
